package cn.com.poc.thirdparty.resource.demand.ai.function.long_memory;

import cn.com.poc.agent_application.entity.Variable;
import cn.com.poc.common.service.RedisService;
import cn.com.poc.common.utils.BlContext;
import cn.com.poc.common.utils.DateUtils;
import cn.com.poc.thirdparty.resource.demand.ai.function.AbstractLargeModelFunction;
import cn.com.yict.framemax.core.i18n.I18nMessageException;
import cn.hutool.json.JSONObject;
import com.google.gson.Gson;
import com.sun.org.apache.regexp.internal.RE;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 长期记忆
 */

@Service
public class SetLongMemoryFunction extends AbstractLargeModelFunction {

    private final String desc = "该方法仅用来保存用户想记录的内容，不能通过该方法进行查询。";

    private final Long expireTime = 30 * 60 * 24L; // 30天有效期


    @Resource
    private RedisService redisService;

    @Override
    public String getDesc() {
        return desc;
    }

    /**
     * 执行函数
     *
     * @param content 内容
     * @param key     唯一标识
     * @return
     */
    @Override
    public String doFunction(String content, String key) {
        // 创建 JSONObject 对象
        JSONObject jsonObject = new JSONObject(content);
        // 提取 content
        String contents = jsonObject.getStr("content");
        String contentKey = SetLongMemoryConstants.REDIS_PREFIX + key + ":" + BlContext.getCurrentUserNotException().getUserId().toString();
        redisService.hset(contentKey, DateUtils.getCurrTime(), contents, expireTime);
        return "SUCCESS";
    }

    @Override
    public List<String> getLLMConfig() {
        Map<String, Object> config = new HashMap<>();
        Map<String, Object> function = new HashMap<>();

        Map<String, Object> content = new HashMap<>();
        content.put("type", "string");
        content.put("description", "内容的详细说明");

        Map<String, Object> properties = new HashMap<>();
        properties.put("content", content);

        Map<String, Object> parameters = new HashMap<>();
        parameters.put("type", "object");
        parameters.put("properties", properties);

        List<String> required = new ArrayList<>();
        required.add("content");
        parameters.put("required", required);


        function.put("name", "set_long_memory");
        function.put("description", desc);
        function.put("parameters", parameters);

        config.put("type", "function");
        config.put("function", function);

        // 将 Map 转换为 JSON 字符串
        Gson gson = new Gson();
        String jsonString = gson.toJson(config);

        List<String> resultList = new ArrayList<>();
        resultList.add(jsonString);
        return resultList;
    }

    @Override
    public List<String> getVariableStructureLLMConfig(List<Variable> variableStructure) {
        throw new I18nMessageException("exception/variable.structure.configuration.is.not.currently.supported");
    }
}
