package cn.com.poc.thirdparty.resource.demand.ai.function.value_memory;

import cn.com.poc.agent_application.entity.Variable;
import cn.com.poc.common.service.RedisService;
import cn.com.poc.common.utils.BlContext;
import cn.com.poc.common.utils.JsonUtils;
import cn.com.poc.thirdparty.resource.demand.ai.entity.dialogue.Function;
import cn.com.poc.thirdparty.resource.demand.ai.function.AbstractLargeModelFunction;
import cn.com.yict.framemax.core.i18n.I18nMessageException;
import cn.hutool.json.JSONObject;
import com.google.gson.Gson;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service
public class SetValueMemoryFunction extends AbstractLargeModelFunction {

    private final String desc = "该方法仅用enum给定的内容名来保存用户想记录的内容值，不可使用该方法进行查询";

    private final Long expireTime = 30 * 60 * 24L; // 30天有效期

    @Resource
    private RedisService redisService;

    @Override
    public String getDesc() {
        return desc;
    }

    @Override
    public String doFunction(String content, String key) {
        String contentKey = SetValueMemoryConstants.REDIS_PREFIX + key + ":" + BlContext.getCurrentUserNotException().getUserId().toString();

        // 创建 JSONObject 对象
        JSONObject jsonObject = new JSONObject(content);
        // 提取 contentName 和 contentValue
        String contentName = jsonObject.getStr("contentName");
        String contentValue = jsonObject.getStr("contentValue");
        Map<String, Object> result = new HashMap<>();
        if (redisService.hasKey(contentKey)) {
            Map<Object, Object> hmget = redisService.hmget(contentKey);
            for (Map.Entry<Object, Object> entry : hmget.entrySet()) {
                if (entry.getKey() instanceof String) {
                    String tempKey = (String) entry.getKey();
                    result.put(tempKey, entry.getValue());
                }
            }
        }
        result.put(contentName, contentValue);
        redisService.hmset(contentKey, result, expireTime);
        return "SUCCESS";
    }

    @Override
    public List<String> getLLMConfig() {
        throw new I18nMessageException("exception/this.method.is.not.supported");
    }

    @Override
    public List<String> getVariableStructureLLMConfig(List<Variable> variableStructure) {
        Map<String, Object> config = new HashMap<>();
        Map<String, Object> function = new HashMap<>();

        Map<String, Object> parameters = new HashMap<>();
        parameters.put("type", "object");

        List<String> required = new ArrayList<>();
        required.add("contentName");
        required.add("contentValue");
        parameters.put("required", required);
        Map<String, Object> properties = new HashMap<>();
        Map<String, Object> contentName = new HashMap<>();
        contentName.put("type", "string");
        contentName.put("description", "内容名");
        List<String> enumList = new ArrayList<>();
        for (Variable variable : variableStructure) {
            enumList.add(variable.getKey());
        }
        contentName.put("enum", enumList); // 设置变量
        Map<String, Object> contentValue = new HashMap<>();
        contentValue.put("type", "string");
        contentValue.put("description", "内容值");
        properties.put("contentName", contentName);
        properties.put("contentValue", contentValue);
        parameters.put("properties", properties);
        parameters.put("type", "object");

        function.put("name", "set_value_memory");
        function.put("description", desc);
        function.put("parameters", parameters);

        config.put("type", "function");
        config.put("function", function);

        // 将 Map 转换为 JSON 字符串
        Gson gson = new Gson();
        String jsonString = gson.toJson(config);

        List<String> resultList = new ArrayList<>();
        resultList.add(jsonString);
        return resultList;
    }
}
