package cn.com.poc.demand;

import cn.com.poc.thirdparty.resource.demand.ai.aggregate.AIDialogueService;
import cn.com.poc.thirdparty.resource.demand.ai.entity.dialogue.Function;
import cn.com.poc.thirdparty.resource.demand.ai.entity.function.FunctionCallResponse;
import cn.com.poc.thirdparty.resource.demand.ai.entity.function.FunctionCallResult;
import cn.com.yict.framemax.core.spring.SingleContextInitializer;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.web.WebAppConfiguration;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration(initializers = SingleContextInitializer.class)
@WebAppConfiguration
public class AiDialogueTest {

    @Resource
    AIDialogueService aiDialogueService;

    @Test
    public void functionCall() {

        String query = "帮我记一下，今天下午需要开会";

        Map<String, Object> content = new HashMap<>();
        content.put("type", "string");
        content.put("description", "内容的详细说明");
        Map<String, Object> properties = new HashMap<>();
        properties.put("content", content);
        Map<String, Object> parameters = new HashMap<>();
        parameters.put("type", "object");
        parameters.put("properties", properties);
        List<String> required = new ArrayList<>();
        required.add("content");
        parameters.put("required", required);


        Function function = new Function();
        function.setName("set_long_memory");
        function.setDescription("该方法仅用来保存用户想记录的内容，不能通过该方法进行查询。");
        function.setParameters(parameters);

        List<Function> functions = new ArrayList<>();
        functions.add(function);

        FunctionCallResponse functionCallResponse = new FunctionCallResponse();
        functionCallResponse.setQuery(query);
        functionCallResponse.setFunctions(functions);
        FunctionCallResult functionCallResult = aiDialogueService.functionCall(functionCallResponse);

        System.out.println(functionCallResult);

    }
}
