package cn.com.poc.thirdparty.resource.demand.ai.function.long_memory;

import cn.com.poc.agent_application.utils.AgentApplicationTools;
import cn.com.poc.common.service.RedisService;
import cn.com.poc.common.utils.BlContext;
import cn.com.poc.common.utils.SpringUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class LongMemory {

    public static List<AgentLongMemoryEntity> get(String identifier) {
        RedisService redisService = SpringUtils.getBean(RedisService.class);
        List<AgentLongMemoryEntity> result = new ArrayList<>();
        // 查询用户相关信息（什么内容都可以）
        String contentKey = SetLongMemoryConstants.REDIS_PREFIX + identifier + ":" + BlContext.getCurrentUserNotException().getUserId().toString();
        Map<Object, Object> map = redisService.hmget(contentKey);
        Set<Object> keySet = map.keySet();

        for (Object mapKey : keySet) {
            AgentLongMemoryEntity entity = new AgentLongMemoryEntity();
            entity.setContent(map.get(mapKey).toString());
            entity.setTimestamp(mapKey.toString());
            result.add(entity);
        }
        return result;
    }

    /**
     * 清除用户在在应用的长期记忆内容
     *
     * @param agentId
     */
    public static void clean(String agentId) {
        RedisService redisService = SpringUtils.getBean(RedisService.class);
        String key = AgentApplicationTools.identifier(agentId, agentId);
        String contentKey = SetLongMemoryConstants.REDIS_PREFIX + key + ":" + BlContext.getCurrentUserNotException().getUserId().toString();
        redisService.del(contentKey);
    }

    /**
     * 根据时间戳 删除用户在应用的长期记忆 某个时间保存的内容
     *
     * @param agentId 应用id
     * @param item    时间戳
     */
    public static void delByKey(String agentId, String item) {
        RedisService redisService = SpringUtils.getBean(RedisService.class);
        String key = AgentApplicationTools.identifier(agentId, agentId);
        String contentKey = SetLongMemoryConstants.REDIS_PREFIX + key + ":" + BlContext.getCurrentUserNotException().getUserId().toString();
        redisService.hdel(contentKey, item);
    }
}
