package cn.com.poc.timbre.constants;


/**
 * 系统环境语言匹配
 * @deprecated
 * 作用在AgentApplication应用的音色配置
 * 获取当前系统环境语言，匹配对应的音色类型
 * 例如：
 * 1.系统环境语言为简体，则匹配音色类型为【中文】,matchLang="zh-CN"
 * 2.系统环境语言为繁体，则匹配音色类型为【粤语】,matchLang="zh-HK"
 * 3.系统环境语言为英语，则匹配音色类型为【英文】,matchLang="en"
 *
 * @author alex.yao
 */
public enum MatchLangEnum {

    zh_CN(0, "zh-CN"),
    zh_HK(1, "zh-HK"),
    en(2, "en");

    private int language;
    private String matchLang;

    MatchLangEnum(int language, String matchLang) {
        this.language = language;
        this.matchLang = matchLang;
    }

    public int getLanguage() {
        return language;
    }

    public String getMatchLang() {
        return matchLang;
    }

    public String getMatchLangByLanguage(int language) {
        for (MatchLangEnum matchLang : MatchLangEnum.values()) {
            if (matchLang.language == language) {
                return matchLang.matchLang;
            }
        }
        return null;
    }
}
