package cn.com.poc.timbre.convert;

import cn.com.poc.timbre.constants.MatchLangEnum;
import cn.com.poc.timbre.dto.GetTimbreDto;
import cn.com.poc.timbre.dto.TimbreInfo;
import cn.com.poc.timbre.entity.BizVoiceTimbreEntity;
import cn.com.poc.timbre.model.BizVoiceTimbreModel;
import cn.hutool.core.collection.ListUtil;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;


public class BizVoiceTimbreConvert {

    public static BizVoiceTimbreEntity modelToEntity(BizVoiceTimbreModel model) {
        BizVoiceTimbreEntity entity = new BizVoiceTimbreEntity();
        entity.setId(model.getId());
        entity.setTimbreId(model.getTimbreId());
        entity.setLanguage(model.getLanguage());
        entity.setTimbreName(model.getTimbreName());
        entity.setTimbreNameEn(model.getTimbreNameEn());
        entity.setTimbreNameTw(model.getTimbreNameTw());
        entity.setVoiceUrl(model.getVoiceUrl());
        entity.setIsDeleted(model.getIsDeleted());
        entity.setCreator(model.getCreator());
        entity.setCreatedTime(model.getCreatedTime());
        entity.setModifier(model.getModifier());
        entity.setModifiedTime(model.getModifiedTime());
        entity.setSysVersion(model.getSysVersion());
        return entity;
    }

    public static BizVoiceTimbreModel entityToModel(BizVoiceTimbreEntity entity) {
        BizVoiceTimbreModel model = new BizVoiceTimbreModel();
        model.setId(entity.getId());
        model.setTimbreId(entity.getTimbreId());
        model.setLanguage(entity.getLanguage());
        model.setTimbreName(entity.getTimbreName());
        model.setTimbreNameEn(entity.getTimbreNameEn());
        model.setTimbreNameTw(entity.getTimbreNameTw());
        model.setVoiceUrl(entity.getVoiceUrl());
        model.setIsDeleted(entity.getIsDeleted());
        model.setCreator(entity.getCreator());
        model.setCreatedTime(entity.getCreatedTime());
        model.setModifier(entity.getModifier());
        model.setModifiedTime(entity.getModifiedTime());
        model.setSysVersion(entity.getSysVersion());
        return model;
    }

    public static GetTimbreDto entityToGetTimbreDto(BizVoiceTimbreEntity entity, Locale locale) {
        GetTimbreDto getTimbreDto = new GetTimbreDto();
        getTimbreDto.setLanguage(entity.getLanguage());
        TimbreInfo timbreInfo = setTimbreInfo(locale, entity);
        getTimbreDto.setTimbreInfo(ListUtil.toList(timbreInfo));
        return getTimbreDto;
    }


    /**
     * entities转换为GetTimbreDto列表
     *
     * @param entities
     * @param locale   语言 zh-cn 中文简体 en 英文 zh-tw 中文繁体
     * @return
     */
    public static List<GetTimbreDto> entitiesToGetTimbreDtoList(List<BizVoiceTimbreEntity> entities, Locale locale) {
        List<GetTimbreDto> dtos = new ArrayList<>();

        // 初始化三个Dto对象 cnDto 中文 enDto 英文 twDto 粤语
        List<TimbreInfo> cnTimbreInfos = new ArrayList<>();
        GetTimbreDto cnDto = new GetTimbreDto();
        cnDto.setLanguage(0);
        cnDto.setMatchLang(MatchLangEnum.zh_CN.getMatchLang());
        cnDto.setTimbreInfo(cnTimbreInfos);


        List<TimbreInfo> cantonTimbreInfos = new ArrayList<>();
        GetTimbreDto cantonDto = new GetTimbreDto();
        cantonDto.setLanguage(1);
        cantonDto.setMatchLang(MatchLangEnum.zh_HK.getMatchLang());
        cantonDto.setTimbreInfo(cantonTimbreInfos);

        List<TimbreInfo> enTimbreInfos = new ArrayList<>();
        GetTimbreDto enDto = new GetTimbreDto();
        enDto.setLanguage(2);
        enDto.setMatchLang(MatchLangEnum.en.getMatchLang());
        enDto.setTimbreInfo(enTimbreInfos);
        for (BizVoiceTimbreEntity entity : entities) {
            Integer language = entity.getLanguage();
            TimbreInfo timbreInfo = setTimbreInfo(locale, entity);
            switch (language.intValue()) {
                case 0:
                    cnTimbreInfos.add(timbreInfo);
                    break;
                case 1:
                    cantonTimbreInfos.add(timbreInfo);
                    break;
                case 2:
                    enTimbreInfos.add(timbreInfo);
                    break;

            }
        }

        dtos.add(cnDto);
        dtos.add(cantonDto);
        dtos.add(enDto);
        return dtos;
    }

    private static TimbreInfo setTimbreInfo(Locale locale, BizVoiceTimbreEntity entity) {
        TimbreInfo timbreInfo = new TimbreInfo();
        timbreInfo.setTimbreId(entity.getTimbreId());
        timbreInfo.setVoiceUrl(entity.getVoiceUrl());
        if (Locale.SIMPLIFIED_CHINESE.equals(locale)) {
            timbreInfo.setTimbreName(entity.getTimbreName());
        } else if (Locale.ENGLISH.equals(locale)) {
            timbreInfo.setTimbreName(entity.getTimbreNameEn());
        } else if (Locale.TRADITIONAL_CHINESE.equals(locale)) {
            timbreInfo.setTimbreName(entity.getTimbreNameTw());
        }
        return timbreInfo;
    }


}