package cn.com.poc.timbre.service.impl;

import cn.com.poc.common.constant.CommonConstant;
import cn.com.yict.framemax.core.service.impl.BaseServiceImpl;
import cn.com.poc.timbre.service.BizVoiceTimbreService;
import cn.com.poc.timbre.model.BizVoiceTimbreModel;
import cn.com.poc.timbre.entity.BizVoiceTimbreEntity;
import cn.com.poc.timbre.convert.BizVoiceTimbreConvert;
import cn.com.poc.timbre.repository.BizVoiceTimbreRepository;
import cn.com.yict.framemax.data.model.PagingInfo;
import org.springframework.stereotype.Service;

import org.apache.commons.collections4.CollectionUtils;

import java.util.ArrayList;
import java.util.stream.Collectors;
import java.util.List;
import javax.annotation.Resource;

import org.springframework.util.Assert;

@Service
public class BizVoiceTimbreServiceImpl extends BaseServiceImpl
        implements BizVoiceTimbreService {

    @Resource
    private BizVoiceTimbreRepository repository;

    public BizVoiceTimbreEntity get(java.lang.Integer id) throws Exception {
        Assert.notNull(id);
        BizVoiceTimbreModel model = this.repository.get(id);
        if (model == null) {
            return null;
        }
        if ("Y".equals(model.getIsDeleted())) {
            return null;
        }
        return BizVoiceTimbreConvert.modelToEntity(model);
    }

    @Override
    public BizVoiceTimbreEntity getByTimbreId(String timbreId)  {
        BizVoiceTimbreModel bizVoiceTimbreModel = new BizVoiceTimbreModel();
        bizVoiceTimbreModel.setTimbreId(timbreId);
        bizVoiceTimbreModel.setIsDeleted(CommonConstant.IsDeleted.N);
        List<BizVoiceTimbreModel> models = this.repository.findByExample(bizVoiceTimbreModel);
        if (CollectionUtils.isNotEmpty(models)) {
            return BizVoiceTimbreConvert.modelToEntity(models.get(0));
        }
        return null;
    }

    public List<BizVoiceTimbreEntity> findByExample(BizVoiceTimbreEntity example, PagingInfo pagingInfo) throws Exception {
        List<BizVoiceTimbreEntity> result = new ArrayList<BizVoiceTimbreEntity>();
        BizVoiceTimbreModel model = new BizVoiceTimbreModel();
        if (example != null) {
            model = BizVoiceTimbreConvert.entityToModel(example);
        }
        model.setIsDeleted("N");
        List<BizVoiceTimbreModel> models = this.repository.findByExample(model, pagingInfo);
        if (CollectionUtils.isNotEmpty(models)) {
            result = models.stream().map(BizVoiceTimbreConvert::modelToEntity).collect(Collectors.toList());
        }
        return result;
    }

    public BizVoiceTimbreEntity save(BizVoiceTimbreEntity entity) throws Exception {
        Assert.notNull(entity);
        entity.setId(null);
        entity.setIsDeleted("N");
        BizVoiceTimbreModel model = BizVoiceTimbreConvert.entityToModel(entity);
        BizVoiceTimbreModel saveModel = this.repository.save(model);
        return BizVoiceTimbreConvert.modelToEntity(saveModel);
    }

    public BizVoiceTimbreEntity update(BizVoiceTimbreEntity entity) throws Exception {
        Assert.notNull(entity);
        Assert.notNull(entity.getId(), "update pk can not be null");
        BizVoiceTimbreModel model = this.repository.get(entity.getId());

        if (entity.getTimbreId() != null) {
            model.setTimbreId(entity.getTimbreId());
        }
        if (entity.getLanguage() != null) {
            model.setLanguage(entity.getLanguage());
        }
        if (entity.getTimbreName() != null) {
            model.setTimbreName(entity.getTimbreName());
        }
        if (entity.getTimbreNameEn() != null) {
            model.setTimbreNameEn(entity.getTimbreNameEn());
        }
        if (entity.getTimbreNameTw() != null) {
            model.setTimbreNameTw(entity.getTimbreNameTw());
        }
        if (entity.getVoiceUrl() != null) {
            model.setVoiceUrl(entity.getVoiceUrl());
        }
        if (entity.getIsDeleted() != null) {
            model.setIsDeleted(entity.getIsDeleted());
        }
        if (entity.getCreator() != null) {
            model.setCreator(entity.getCreator());
        }
        if (entity.getCreatedTime() != null) {
            model.setCreatedTime(entity.getCreatedTime());
        }
        if (entity.getModifier() != null) {
            model.setModifier(entity.getModifier());
        }
        if (entity.getModifiedTime() != null) {
            model.setModifiedTime(entity.getModifiedTime());
        }
        if (entity.getSysVersion() != null) {
            model.setSysVersion(entity.getSysVersion());
        }
        BizVoiceTimbreModel saveModel = this.repository.save(model);
        return BizVoiceTimbreConvert.modelToEntity(saveModel);
    }

    public void deletedById(java.lang.Integer id) throws Exception {
        Assert.notNull(id);
        BizVoiceTimbreModel model = this.repository.get(id);
        if (model != null) {
            if ("N".equals(model.getIsDeleted())) {
                model.setIsDeleted("Y");
                this.repository.save(model);
            }
        }
    }

}