package cn.com.poc.user.builder;

import cn.com.poc.common.service.JudgeCodeService;
import cn.com.poc.common.utils.Assert;
import cn.com.poc.common.utils.StringUtils;
import cn.com.poc.user.dto.MemberLoginRequestDto;
import cn.com.poc.user.entity.MemberInfoEntity;
import cn.com.poc.user.service.BizMemberInfoService;
import cn.com.yict.framemax.core.i18n.I18nMessageException;
import cn.com.yict.framemax.data.model.BaseModel;
import cn.com.yict.framemax.frame.service.FmxParamConfigService;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

@Component
public class EmailLoginChannel implements LoginChannelService {
    @Resource
    private BizMemberInfoService bizMemberInfoService;
    @Resource
    private JudgeCodeService judgeCodeService;
    @Resource
    private FmxParamConfigService fmxParamConfigService;

    @Override
    public BaseModel doLogin(MemberLoginRequestDto memberLoginRequest) throws Exception {
        Assert.notBlank(memberLoginRequest.getAccount());
        Assert.notBlank(memberLoginRequest.getAuthCode());

        if (!judgeCodeService.judgeCode(memberLoginRequest.getAccount(), memberLoginRequest.getAuthCode())) {
            throw new I18nMessageException("exception/verification.code.is.incorrect.please.re-enter");
        }

        MemberInfoEntity memberEntityByAccount = bizMemberInfoService.getMemberEntityByAccount(memberLoginRequest.getAccount());
        if (memberEntityByAccount == null) { //用户没有注册过 需要注册
            MemberInfoEntity memberInfoEntity = new MemberInfoEntity();
            memberInfoEntity.setAccount(memberLoginRequest.getAccount());
            memberInfoEntity.setNickName(memberLoginRequest.getAccount());
            memberInfoEntity.setEmail(memberLoginRequest.getAccount());
            String param = fmxParamConfigService.getParam("member.default.avatar");
            if (StringUtils.isNoneBlank(param)) {
                memberInfoEntity.setAvatarUrl(param);
            }
            return bizMemberInfoService.createMemberInfo(memberInfoEntity);
        }

        return memberEntityByAccount;
    }
}
