package cn.com.yict.framemax.frame.model;

import cn.com.yict.framemax.data.model.BaseModelClass;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.*;
import java.io.Serializable;

/**
 * Model class for FMX_ROLE
 * 角色表
 */
@Entity
@Table(name = "FMX_ROLE")
@DynamicInsert
@DynamicUpdate
public class FmxRoleModel extends BaseModelClass implements Serializable {

    private static final long serialVersionUID = 1L;
    
    
  
    /** ROLE_ID
    *角色标识
    */ 
    private Long roleId;
    
    @Column(name = "ROLE_ID")
	@Id @GeneratedValue(strategy = GenerationType.AUTO)   
    public Long getRoleId(){
        return this.roleId;
    }
    
    public void setRoleId(Long roleId){
        this.roleId = roleId;
        super.addValidField("roleId");
    }

    /** CORP_INFO_ID
     * 数据隔离ID 【企业微信 corpInfoId】
     */
    private String corpInfoId;

    @Column(name = "CORP_INFO_ID",length = 100)
    public String getCorpInfoId() {
        return corpInfoId;
    }

    public void setCorpInfoId(String isolationId) {
        this.corpInfoId = isolationId;
        super.addValidField("corpInfoId");
    }

    /** ROLE_DESC
    *角色备注
    */ 
    private String roleDesc;
    
    @Column(name = "ROLE_DESC")
    public String getRoleDesc(){
        return this.roleDesc;
    }
    
    public void setRoleDesc(String roleDesc){
        this.roleDesc = roleDesc;
        super.addValidField("roleDesc");
    }
    
  
    /** ROLE_NAME
    *角色名称
    */ 
    private String roleName;
    
    @Column(name = "ROLE_NAME")
    public String getRoleName(){
        return this.roleName;
    }
    
    public void setRoleName(String roleName){
        this.roleName = roleName;
        super.addValidField("roleName");
    }
    
    /** ROLE_CODE
    *角色代码
    */ 
    private String roleCode;
    
    @Column(name = "ROLE_CODE")
    public String getRoleCode(){
        return this.roleCode;
    }
    
    public void setRoleCode(String roleCode){
        this.roleCode = roleCode;
        super.addValidField("roleCode");
    }    
  
    /** ROLE_URL
    *默认打开菜单编码
    */ 
    private String roleUrl;
    
    @Column(name = "ROLE_URL")
    public String getRoleUrl(){
        return this.roleUrl;
    }
    
    public void setRoleUrl(String roleUrl){
        this.roleUrl = roleUrl;
        super.addValidField("roleUrl");
    }
    
    /** ROLE_TYPE
    *角色类型
    */ 
    private String roleType;
    
    @Column(name = "ROLE_TYPE",length = 20)
    public String getRoleType(){
        return this.roleType;
    }
    
    public void setRoleType(String roleType){
        this.roleType = roleType;
        super.addValidField("roleType");
    }
  
    /** CREATOR
    *创建人
    */ 
    private String creator;
    
    @Column(name = "CREATOR")
    public String getCreator(){
        return this.creator;
    }
    
    public void setCreator(String creator){
        this.creator = creator;
        super.addValidField("creator");
    }
    
  
    /** CREATED_TIME
    *创建时间
    */ 
    private java.util.Date createdTime;
    
    @Column(name = "CREATED_TIME")
    public java.util.Date getCreatedTime(){
        return this.createdTime;
    }
    
    public void setCreatedTime(java.util.Date createdTime){
        this.createdTime = createdTime;
        super.addValidField("createdTime");
    }
    
    /** MODIFIER
    *修改人
    */ 
    private String modifier;
    
    @Column(name = "MODIFIER")
    public String getModifier(){
        return this.modifier;
    }
    
    public void setModifier(String modifier){
        this.modifier = modifier;
        super.addValidField("modifier");
    }
    
  
    /** MODIFIED_TIME
    *修改时间
    */ 
    private java.util.Date modifiedTime;
    
    @Column(name = "MODIFIED_TIME")
    public java.util.Date getModifiedTime(){
        return this.modifiedTime;
    }
    
    public void setModifiedTime(java.util.Date modifiedTime){
        this.modifiedTime = modifiedTime;
        super.addValidField("modifiedTime");
    }
    
    /**
     * 版本号
     */
    private Integer sysVersion;
    
    @Column(name = "SYS_VERSION")
    @Version
    public Integer getSysVersion(){
        return this.sysVersion;
    }
    
    public void setSysVersion(Integer sysVersion){
        this.sysVersion = sysVersion;
        super.addValidField("sysVersion");
    }
}