package cn.com.poc;


import cn.com.poc.agent_application.aggregate.AgentApplicationInfoService;
import cn.com.poc.agent_application.entity.Variable;
import cn.com.poc.agent_application.utils.AgentApplicationTools;
import cn.com.poc.common.service.RedisService;
import cn.com.poc.expose.aggregate.AgentApplicationService;
import cn.com.poc.thirdparty.resource.demand.ai.function.html_reader.HtmlReaderFunction;
import cn.com.poc.thirdparty.resource.demand.ai.function.memory_variable_writer.MemoryVariableWriter;
import cn.com.yict.framemax.core.spring.SingleContextInitializer;
import com.google.common.collect.Lists;
import io.github.furstenheim.*;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.web.WebAppConfiguration;

import javax.annotation.Resource;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.*;

@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration(initializers = SingleContextInitializer.class)
@WebAppConfiguration
public class AgentApplicationInfoTest {


    @Resource
    private AgentApplicationInfoService applicationInfoService;

    @Resource
    private RedisService redisService;

    @Resource
    private AgentApplicationService agentApplicationService;

    @Test
    public void del() {
    }

    @Test
    public void html2MD() throws IOException {
        // 创建资源符对象
        URL url = new URL("https://blog.csdn.net/jxlhljh/article/details/124506103");
        // 创建连接
        URLConnection conn = url.openConnection();
        // 获取输入流
        InputStream inputStream = conn.getInputStream();
        // 缓冲区，读取输入流内容，64KB
        char[] buffer = new char[1024 * 64];
        int len;
        StringBuilder sb = new StringBuilder();
        // 转换为字符流
        InputStreamReader isr = new InputStreamReader(inputStream);
        // 循环读取
        while ((len = isr.read(buffer)) != -1) {
            sb.append(buffer, 0, len);
        }
//        System.out.println(sb.toString());
        // 关闭资源
        inputStream.close();
        isr.close();

        String htmlStr = sb.toString();

        OptionsBuilder optionsBuilder = OptionsBuilder.anOptions();
        Options options = optionsBuilder.withBr("-")
                .withLinkStyle(LinkStyle.REFERENCED)
                .withLinkReferenceStyle(LinkReferenceStyle.SHORTCUT)
                // more options
                .build();
        CopyDown converter = new CopyDown(options);
        String markdownText = converter.convert(htmlStr);

        FileOutputStream fileOutputStream = new FileOutputStream("D:\\test.md");
        fileOutputStream.write(markdownText.getBytes());
        fileOutputStream.flush();
        fileOutputStream.close();
//        System.out.println(markdownText);

    }


    /**
     * Agent Ӧ�ñ��⣬��������
     */
    @Test
    public void createAgentTitleAndDesc() {
        String input = "���Ա���";
        System.out.println(applicationInfoService.createAgentTitleAndDesc(input));
    }

    @Test
    public void knowledgeTest() {
        ArrayList<String> list = new ArrayList<String>() {{
        }};
        System.out.println(list.toString());
    }

    @Test
    public void test() {
        List<Object> list = Lists.newArrayList("1", "2", "3", "4", "5", "6", "7", "8", "9", "1");
        redisService.lSet("key", list);
//        redisService.sSet("key",1);

    }


    @Test
    public void createRecommendQuestion() throws InterruptedException {
        agentApplicationService.createRecommendQuestion();
    }

    @Test
    public void getValueMemory() {
    }

    @Test
    public void getFunctionConfig() {

        System.out.println(new HtmlReaderFunction().getLLMConfig());
    }


    @Test
    public void updateStructVariable() {
        String agentId = "1";
        List<Variable> originals = null;
        List<Variable> transformed = null;
        String identifier = AgentApplicationTools.identifier(agentId, agentId);
        if (CollectionUtils.isEmpty(transformed)) {
            // 清除所有字段
            MemoryVariableWriter.clean(identifier);
        }
        // 原【变量记忆】为空，则不需要处理
        if (originals == null) {
            return;
        }
        // 1. 获取需要删除的字段集合
        // 2. 获取需要更新值的字段集合
        Set<String> delKeys = new HashSet<>();
        Set<String> updateKeys = new HashSet<>();
        for (Variable variable : originals) {
            String key = variable.getKey();
            boolean needDel = transformed.stream().noneMatch(v -> v.getKey().equals(key));
            if (needDel) {
                delKeys.add(key);
            }

            boolean needUpdate = transformed.stream().anyMatch(v -> v.getKey().equals(key));
            if (needUpdate) {
                Optional<Variable> target = transformed.stream().filter(v -> v.getKey().equals(key)).findFirst();
                if (StringUtils.isBlank(target.get().getVariableDefault())) {
                    continue;
                }
                Map<Object, Object> map = MemoryVariableWriter.get(identifier);
                String value = map.get(key).toString();
                if (StringUtils.isBlank(value)) {
                    updateKeys.add(key);
                }
            }
        }
        // 3. 获取需要新增的字段集合
        Set<String> addKeys = new HashSet<>();
        for (Variable variable : transformed) {
            String key = variable.getKey();
            boolean needAdd = originals.stream().noneMatch(v -> v.getKey().equals(key));
            if (needAdd) {
                addKeys.add(key);
            }
        }
        // 删除
        if (!delKeys.isEmpty()) {
            MemoryVariableWriter.delItem(identifier, delKeys.toArray(new String[0]));
        }

        if (!addKeys.isEmpty()) {
            Map<String, Object> map = new HashMap<>();
            for (String key : addKeys) {
                Variable variable = transformed.stream().filter(v -> v.getKey().equals(key)).findFirst().get();
                map.put(variable.getKey(), variable.getVariableDefault());
            }
            MemoryVariableWriter.addItem(identifier, map);
        }
        if (!updateKeys.isEmpty()) {
            Map<String, Object> map = new HashMap<>();
            for (String key : updateKeys) {
                Variable variable = transformed.stream().filter(v -> v.getKey().equals(key)).findFirst().get();
                map.put(variable.getKey(), variable.getVariableDefault());
            }
            MemoryVariableWriter.addItem(identifier, map);
        }
    }

}
