package cn.com.poc.agent_application.model;

import java.io.Serializable;

import cn.com.yict.framemax.data.model.BaseModelClass;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Id;

import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Version;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;

/**
 * Model class for biz_agent_application_publish
 * Agent应用发布配置
 */
@Entity
@Table(name = "biz_agent_application_publish")
@DynamicInsert
@DynamicUpdate
public class BizAgentApplicationPublishModel extends BaseModelClass implements Serializable {

    private static final long serialVersionUID = 1L;


    /**
     * id
     * 自增ID
     */
    private java.lang.Integer id;

    @Column(name = "id", length = 10)
    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    public java.lang.Integer getId() {
        return this.id;
    }

    public void setId(java.lang.Integer id) {
        this.id = id;
        super.addValidField("id");
    }


    /**
     * member_id
     * 创建应用的用户ID
     */
    private java.lang.Integer memberId;

    @Column(name = "member_id", length = 10)
    public java.lang.Integer getMemberId() {
        return this.memberId;
    }

    public void setMemberId(java.lang.Integer memberId) {
        this.memberId = memberId;
        super.addValidField("memberId");
    }


    /**
     * agent_id
     * agent应用ID
     */
    private java.lang.String agentId;

    @Column(name = "agent_id", length = 200)
    public java.lang.String getAgentId() {
        return this.agentId;
    }

    public void setAgentId(java.lang.String agentId) {
        this.agentId = agentId;
        super.addValidField("agentId");
    }


    /**
     * agent_avatar
     * 应用头像ICON地址
     */
    private java.lang.String agentAvatar;

    @Column(name = "agent_avatar", length = 200)
    public java.lang.String getAgentAvatar() {
        return this.agentAvatar;
    }

    public void setAgentAvatar(java.lang.String agentAvatar) {
        this.agentAvatar = agentAvatar;
        super.addValidField("agentAvatar");
    }


    /**
     * agent_title
     * 应用标题
     */
    private java.lang.String agentTitle;

    @Column(name = "agent_title", length = 50)
    public java.lang.String getAgentTitle() {
        return this.agentTitle;
    }

    public void setAgentTitle(java.lang.String agentTitle) {
        this.agentTitle = agentTitle;
        super.addValidField("agentTitle");
    }


    /**
     * agent_desc
     * 应用描述
     */
    private java.lang.String agentDesc;

    @Column(name = "agent_desc", length = 100)
    public java.lang.String getAgentDesc() {
        return this.agentDesc;
    }

    public void setAgentDesc(java.lang.String agentDesc) {
        this.agentDesc = agentDesc;
        super.addValidField("agentDesc");
    }


    /**
     * agent_system
     * 角色指令
     */
    private java.lang.String agentSystem;

    @Column(name = "agent_system", length = 2147483647)
    public java.lang.String getAgentSystem() {
        return this.agentSystem;
    }

    public void setAgentSystem(java.lang.String agentSystem) {
        this.agentSystem = agentSystem;
        super.addValidField("agentSystem");
    }


    /**
     * preamble
     * 开场白
     */
    private java.lang.String preamble;

    @Column(name = "preamble", length = 2147483647)
    public java.lang.String getPreamble() {
        return this.preamble;
    }

    public void setPreamble(java.lang.String preamble) {
        this.preamble = preamble;
        super.addValidField("preamble");
    }

    /**
     * variable_structure
     * 变量结构
     */
    private java.lang.String variableStructure;

    @Column(name = "variable_structure", length = 2147483647)
    public java.lang.String getVariableStructure() {
        return this.variableStructure;
    }

    public void setVariableStructure(java.lang.String variableStructure) {
        this.variableStructure = variableStructure;
        super.addValidField("variableStructure");
    }


    /**
     * featured_questions
     * 推荐问
     */
    private java.lang.String featuredQuestions;

    @Column(name = "featured_questions", length = 1073741824)
    public java.lang.String getFeaturedQuestions() {
        return this.featuredQuestions;
    }

    public void setFeaturedQuestions(java.lang.String featuredQuestions) {
        this.featuredQuestions = featuredQuestions;
        super.addValidField("featuredQuestions");
    }


    /**
     * communication_turn
     * 对话上下文保存轮次 0-100
     */
    private java.lang.Integer communicationTurn;

    @Column(name = "communication_turn", length = 10)
    public java.lang.Integer getCommunicationTurn() {
        return this.communicationTurn;
    }

    public void setCommunicationTurn(java.lang.Integer communicationTurn) {
        this.communicationTurn = communicationTurn;
        super.addValidField("communicationTurn");
    }


    /**
     * continuous_question_status
     * 追问状态   默认-default   自定义-customizable  关闭-close
     */
    private java.lang.String continuousQuestionStatus;

    @Column(name = "continuous_question_status", length = 15)
    public java.lang.String getContinuousQuestionStatus() {
        return this.continuousQuestionStatus;
    }

    public void setContinuousQuestionStatus(java.lang.String continuousQuestionStatus) {
        this.continuousQuestionStatus = continuousQuestionStatus;
        super.addValidField("continuousQuestionStatus");
    }


    /**
     * continuous_question_system
     * 追问prompt
     */
    private java.lang.String continuousQuestionSystem;

    @Column(name = "continuous_question_system", length = 2147483647)
    public java.lang.String getContinuousQuestionSystem() {
        return this.continuousQuestionSystem;
    }

    public void setContinuousQuestionSystem(java.lang.String continuousQuestionSystem) {
        this.continuousQuestionSystem = continuousQuestionSystem;
        super.addValidField("continuousQuestionSystem");
    }


    /**
     * continuous_question_turn
     * 追问轮次 1-5
     */
    private java.lang.Integer continuousQuestionTurn;

    @Column(name = "continuous_question_turn", length = 10)
    public java.lang.Integer getContinuousQuestionTurn() {
        return this.continuousQuestionTurn;
    }

    public void setContinuousQuestionTurn(java.lang.Integer continuousQuestionTurn) {
        this.continuousQuestionTurn = continuousQuestionTurn;
        super.addValidField("continuousQuestionTurn");
    }


    /**
     * knowledge_ids
     * 知识库ID
     */
    private java.lang.String knowledgeIds;

    @Column(name = "knowledge_ids", length = 1073741824)
    public java.lang.String getKnowledgeIds() {
        return this.knowledgeIds;
    }

    public void setKnowledgeIds(java.lang.String knowledgeIds) {
        this.knowledgeIds = knowledgeIds;
        super.addValidField("knowledgeIds");
    }

    /**
     * knowledge_search_type
     * 知识库检索方式
     * 1、混合检索  - MIX
     * 2、语义检索  - SEMANTIC
     * 3. 关键词检索 - KEY_WORD
     */
    private java.lang.String knowledgeSearchType;

    @Column(name = "knowledge_search_type", length = 10)
    public String getKnowledgeSearchType() {
        return knowledgeSearchType;
    }

    public void setKnowledgeSearchType(String knowledgeSearchType) {
        this.knowledgeSearchType = knowledgeSearchType;
        super.addValidField("knowledgeSearchType");
    }


    /**
     * knowledge_similarity
     * 知识库相似度阈值
     */
    private Double knowledgeSimilarity;

    @Column(name = "knowledge_similarity", length = 12)
    public Double getKnowledgeSimilarity() {
        return knowledgeSimilarity;
    }

    public void setKnowledgeSimilarity(Double knowledgeSimilarity) {
        this.knowledgeSimilarity = knowledgeSimilarity;
        super.addValidField("knowledgeSimilarity");
    }

    /**
     * knowledge_n_result
     * 知识库检索结果数量
     */
    private Integer knowledgeNResult;

    @Column(name = "knowledge_n_result", length = 10)
    public Integer getKnowledgeNResult() {
        return knowledgeNResult;
    }

    public void setKnowledgeNResult(Integer knowledgeNResult) {
        this.knowledgeNResult = knowledgeNResult;
        super.addValidField("knowledgeNResult");
    }

    /**
     * knowledge_response_type
     * 知识库回复类型
     * default-默认
     * custom-自定义
     */
    private String knowledgeResponseType;

    @Column(name = "knowledge_response_type", length = 10)
    public String getKnowledgeResponseType() {
        return knowledgeResponseType;
    }

    public void setKnowledgeResponseType(String knowledgeResponseType) {
        this.knowledgeResponseType = knowledgeResponseType;
        super.addValidField("knowledgeResponseType");
    }


    /**
     * knowledge_custom_response
     * 知识库自定义回复内容
     */
    private String knowledgeCustomResponse;

    @Column(name = "knowledge_custom_response", length = 2147483647)
    public String getKnowledgeCustomResponse() {
        return knowledgeCustomResponse;
    }

    public void setKnowledgeCustomResponse(String knowledgeCustomResponse) {
        this.knowledgeCustomResponse = knowledgeCustomResponse;
        super.addValidField("knowledgeCustomResponse");
    }

    /**
     * large_model
     * 问答模型
     */
    private java.lang.String largeModel;

    @Column(name = "large_model", length = 25)
    public java.lang.String getLargeModel() {
        return this.largeModel;
    }

    public void setLargeModel(java.lang.String largeModel) {
        this.largeModel = largeModel;
        super.addValidField("largeModel");
    }


    /**
     * top_p
     * 对话模型 多样性 [0-1.00]
     */
    private java.lang.Float topP;

    @Column(name = "top_p", length = 12)
    public java.lang.Float getTopP() {
        return this.topP;
    }

    public void setTopP(java.lang.Float topP) {
        this.topP = topP;
        super.addValidField("topP");
    }


    /**
     * temperature
     * 对话模型 温度 [0-1.00]
     */
    private java.lang.Float temperature;

    @Column(name = "temperature", length = 12)
    public java.lang.Float getTemperature() {
        return this.temperature;
    }

    public void setTemperature(java.lang.Float temperature) {
        this.temperature = temperature;
        super.addValidField("temperature");
    }


    /**
     * unit_ids
     * 组件ID
     */
    private java.lang.String unitIds;

    @Column(name = "unit_ids", length = 1073741824)
    public java.lang.String getUnitIds() {
        return this.unitIds;
    }

    public void setUnitIds(java.lang.String unitIds) {
        this.unitIds = unitIds;
        super.addValidField("unitIds");
    }

    /**
     * is_long_memory
     * 是否开启长期记忆 1、Y 是 2、N 否
     */
    private java.lang.String isLongMemory;

    @Column(name = "is_long_memory", length = 1)
    public java.lang.String getIsLongMemory() {
        return this.isLongMemory;
    }

    public void setIsLongMemory(java.lang.String isLongMemory) {
        this.isLongMemory = isLongMemory;
        super.addValidField("isLongMemory");
    }

    private java.lang.String isDocumentParsing;

    @Column(name = "is_document_parsing", length = 1)
    public java.lang.String getIsDocumentParsing() {
        return this.isDocumentParsing;
    }

    public void setIsDocumentParsing(java.lang.String isDocumentParsing) {
        this.isDocumentParsing = isDocumentParsing;
        super.addValidField("isDocumentParsing");
    }

    /**
     * voice_config
     * 声音配置 default_open-是否默认开启  timbre_id-音色
     */
    private java.lang.String voiceConfig;

    @Column(name = "voice_config", length = 2147483647)
    public java.lang.String getVoiceConfig() {
        return this.voiceConfig;
    }

    public void setVoiceConfig(String voiceConfig) {
        this.voiceConfig = voiceConfig;
        super.addValidField("voiceConfig");
    }


    /**
     * is_deleted
     * 是否删除 1、Y 是 2、N 否
     */
    private java.lang.String isDeleted;

    @Column(name = "is_deleted", length = 1)
    public java.lang.String getIsDeleted() {
        return this.isDeleted;
    }

    public void setIsDeleted(java.lang.String isDeleted) {
        this.isDeleted = isDeleted;
        super.addValidField("isDeleted");
    }


    /**
     * CREATOR
     * 创建人
     */
    private java.lang.String creator;

    @Column(name = "CREATOR", length = 225)
    public java.lang.String getCreator() {
        return this.creator;
    }

    public void setCreator(java.lang.String creator) {
        this.creator = creator;
        super.addValidField("creator");
    }


    /**
     * CREATED_TIME
     * 创建时间
     */
    private java.util.Date createdTime;

    @Column(name = "CREATED_TIME", length = 19)
    public java.util.Date getCreatedTime() {
        return this.createdTime;
    }

    public void setCreatedTime(java.util.Date createdTime) {
        this.createdTime = createdTime;
        super.addValidField("createdTime");
    }


    /**
     * MODIFIER
     * 修改人
     */
    private java.lang.String modifier;

    @Column(name = "MODIFIER", length = 225)
    public java.lang.String getModifier() {
        return this.modifier;
    }

    public void setModifier(java.lang.String modifier) {
        this.modifier = modifier;
        super.addValidField("modifier");
    }


    /**
     * MODIFIED_TIME
     * 修改时间
     */
    private java.util.Date modifiedTime;

    @Column(name = "MODIFIED_TIME", length = 19)
    public java.util.Date getModifiedTime() {
        return this.modifiedTime;
    }

    public void setModifiedTime(java.util.Date modifiedTime) {
        this.modifiedTime = modifiedTime;
        super.addValidField("modifiedTime");
    }


    /**
     * SYS_VERSION
     * 乐观锁,版本号
     */
    private java.lang.Integer sysVersion;

    @Column(name = "SYS_VERSION", length = 10)
    @Version
    public java.lang.Integer getSysVersion() {
        return this.sysVersion;
    }

    public void setSysVersion(java.lang.Integer sysVersion) {
        this.sysVersion = sysVersion;
        super.addValidField("sysVersion");
    }


}