package cn.com.poc.common.rest;

import cn.com.yict.framemax.core.i18n.I18nMessageException;
import cn.com.yict.framemax.core.rest.BaseRest;
import cn.com.yict.framemax.web.permission.Access;
import cn.com.yict.framemax.web.permission.Permission;
import org.springframework.web.bind.annotation.RequestParam;

@Permission(Access.Anonymous)
public interface JudgeCodeRest extends BaseRest {
    /**
     * 校验验证码是否正确
     *
     * @param account,code
     * @throws Exception
     */
    boolean judgeCode(@RequestParam String account, @RequestParam String code) throws Exception;

    /**
     * 校验验证码是否正确,正确的话就返回授权码，可以给别的业务操作
     *
     * @param account,code
     * @throws Exception
     */
    String judgeCodeReturnAuthCode(@RequestParam String account, @RequestParam String code)  throws Exception;
}
