package cn.com.poc.equity.service.impl;	

import cn.com.yict.framemax.core.service.impl.BaseServiceImpl;
import cn.com.poc.equity.service.BizMemberEquityPayOrderLogService;
import cn.com.poc.equity.model.BizMemberEquityPayOrderLogModel;
import cn.com.poc.equity.entity.BizMemberEquityPayOrderLogEntity;
import cn.com.poc.equity.convert.BizMemberEquityPayOrderLogConvert;
import cn.com.poc.equity.repository.BizMemberEquityPayOrderLogRepository;
import cn.com.yict.framemax.data.model.PagingInfo;
import org.springframework.stereotype.Service;

import org.apache.commons.collections4.CollectionUtils;
import java.util.ArrayList;
import java.util.stream.Collectors;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.util.Assert;

@Service
public class BizMemberEquityPayOrderLogServiceImpl extends BaseServiceImpl
 			 implements BizMemberEquityPayOrderLogService {
   
   @Resource
   private BizMemberEquityPayOrderLogRepository repository;
    			 
   public BizMemberEquityPayOrderLogEntity get(java.lang.Long id) throws Exception{
        Assert.notNull(id);
        BizMemberEquityPayOrderLogModel model =  this.repository.get(id);
        if (model == null){
            return null;
        }
        if ("Y".equals(model.getIsDeleted())){
            return null;
        }
        return BizMemberEquityPayOrderLogConvert.modelToEntity(model);
   }

       
   public List<BizMemberEquityPayOrderLogEntity> findByExample(BizMemberEquityPayOrderLogEntity example,PagingInfo pagingInfo){
        List<BizMemberEquityPayOrderLogEntity> result = new  ArrayList<BizMemberEquityPayOrderLogEntity>();
        BizMemberEquityPayOrderLogModel model = new BizMemberEquityPayOrderLogModel();
        if (example != null){
            model = BizMemberEquityPayOrderLogConvert.entityToModel(example);
        }
        model.setIsDeleted("N");
        List<BizMemberEquityPayOrderLogModel> models = this.repository.findByExample(model,"pay_time desc",pagingInfo);
        if (CollectionUtils.isNotEmpty(models)) {
            result = models.stream().map(BizMemberEquityPayOrderLogConvert::modelToEntity).collect(Collectors.toList());
        }
        return result;
    }

    public BizMemberEquityPayOrderLogEntity save(BizMemberEquityPayOrderLogEntity entity) throws Exception{
        Assert.notNull(entity);
        entity.setId(null);
        entity.setIsDeleted("N");
        BizMemberEquityPayOrderLogModel model = BizMemberEquityPayOrderLogConvert.entityToModel(entity);
        BizMemberEquityPayOrderLogModel saveModel =  this.repository.save(model);
        return BizMemberEquityPayOrderLogConvert.modelToEntity(saveModel);
    }

    public BizMemberEquityPayOrderLogEntity update(BizMemberEquityPayOrderLogEntity entity) throws Exception{
        Assert.notNull(entity);
        Assert.notNull(entity.getId(),"update pk can not be null");
        BizMemberEquityPayOrderLogModel model = this.repository.get(entity.getId());

       if (entity.getMemberId() != null){
        model.setMemberId(entity.getMemberId());
       }
       if (entity.getPayOrderSn() != null){
        model.setPayOrderSn(entity.getPayOrderSn());
       }
       if (entity.getPayAmount() != null){
        model.setPayAmount(entity.getPayAmount());
       }
       if (entity.getCurrency() != null){
        model.setCurrency(entity.getCurrency());
       }
       if (entity.getType() != null){
        model.setType(entity.getType());
       }
       if (entity.getDomain() != null){
        model.setDomain(entity.getDomain());
       }
       if (entity.getExpiredNum() != null){
        model.setExpiredNum(entity.getExpiredNum());
       }
       if (entity.getExpiredType() != null){
        model.setExpiredType(entity.getExpiredType());
       }
       if (entity.getPayChannel() != null){
        model.setPayChannel(entity.getPayChannel());
       }
       if (entity.getPayTime() != null){
        model.setPayTime(entity.getPayTime());
       }
       if (entity.getIsDeleted() != null){
        model.setIsDeleted(entity.getIsDeleted());
       }
       if (entity.getCreator() != null){
        model.setCreator(entity.getCreator());
       }
       if (entity.getCreatedTime() != null){
        model.setCreatedTime(entity.getCreatedTime());
       }
       if (entity.getModifier() != null){
        model.setModifier(entity.getModifier());
       }
       if (entity.getModifiedTime() != null){
        model.setModifiedTime(entity.getModifiedTime());
       }
       if (entity.getSysVersion() != null){
        model.setSysVersion(entity.getSysVersion());
       }
        BizMemberEquityPayOrderLogModel saveModel =  this.repository.save(model);
        return BizMemberEquityPayOrderLogConvert.modelToEntity(saveModel);
    }

    public void deletedById(java.lang.Long id) throws Exception{
        Assert.notNull(id);
        BizMemberEquityPayOrderLogModel model =  this.repository.get(id);
        if (model != null){
            if ("N".equals(model.getIsDeleted())){
                model.setIsDeleted("Y");
                this.repository.save(model);
            }
       }
   }
    
}