package cn.com.poc.expose.aggregate;

import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * Agent应用-API服务接口
 *
 * @author alex.yao
 * @date 2024/12/19
 */
public interface AgentApplicationApiService {

    /**
     * 新建对话ID
     * 有效期为7天，过期后将无法使用。
     *
     * @param apiKey    API密钥
     * @param apiSecret API密钥
     * @return 对话ID
     */
    String conversation(String apiKey, String apiSecret, String agentId) throws Exception;

    /**
     * API-对话
     *
     * @param apiKey              API密钥
     * @param apiSecret           API密钥
     * @param conversationId      对话ID
     * @param fileIds             文件ID列表
     * @param query               消息
     * @param stream              是否流式输出
     * @param imageUrl            图片URL
     * @param httpServletResponse
     */
    void completions(String apiKey, String apiSecret, String conversationId, List<String> fileIds, String query, boolean stream, String imageUrl, HttpServletResponse httpServletResponse) throws Exception;

    /**
     * 上传文件
     * 该接口用于在对话中上传文件供大模型处理，文件的有效期为7天并且不超过对话的有效期。一次只能上传一个文件。
     *
     * @param apiKey         API密钥
     * @param apiSecret      API密钥
     * @param agentId        Agent ID
     * @param conversationId 对话ID
     * @param file           文件
     * @return 文件ID
     */
    String uploadFile(String apiKey, String apiSecret, String agentId, String conversationId, MultipartFile file) throws Exception;
}
