package cn.com.poc.thirdparty.resource.demand.ai.function.top_search;

import cn.com.poc.agent_application.entity.Variable;
import cn.com.poc.common.utils.JsonUtils;
import cn.com.poc.thirdparty.resource.demand.ai.function.AbstractLargeModelFunction;
import cn.com.poc.thirdparty.resource.demand.ai.function.entity.FunctionLLMConfig;
import cn.com.poc.thirdparty.resource.tianju.api.TianApi;
import cn.com.poc.thirdparty.resource.tianju.api.entity.TianCommonResult;
import cn.com.poc.thirdparty.resource.tianju.api.entity.TianResult;
import cn.com.poc.thirdparty.resource.tianju.api.entity.TianToutiaoTopSearch;
import cn.hutool.core.collection.ListUtil;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.List;

/**
 * @author alex.yao
 * @date 2025/1/17
 */
@Component
public class ToutiaoTopSearchFunction extends AbstractLargeModelFunction {
    private final String DESC = "该方法获取今天头条的头条热搜榜";

    private final FunctionLLMConfig functionLLMConfig = new FunctionLLMConfig.FunctionLLMConfigBuilder()
            .name("toutiao_search_top")
            .description(DESC)
//            .parameters(new Parameters("object").addProperties("content", new Properties("string", "内容的详细说明")))
            .build();

    @Resource
    private TianApi tianApi;

    @Override
    public String doFunction(String content, String identifier) {
        TianCommonResult<TianToutiaoTopSearch> toutiaoTopSearch = tianApi.getToutiaoTopSearch();
        TianResult<TianToutiaoTopSearch> result = toutiaoTopSearch.getResult();
        List<TianToutiaoTopSearch> list = result.getList();
        return JsonUtils.serialize(list);
    }

    @Override
    public String getDesc() {
        return DESC;
    }

    @Override
    public List<String> getLLMConfig() {
        return ListUtil.toList(JsonUtils.serialize(functionLLMConfig));
    }

    @Override
    public List<String> getLLMConfig(List<Variable> variableStructure) {
        return getLLMConfig();
    }
}
