package cn.com.poc.thirdparty.resource.demand.pay.service;

import cn.com.poc.thirdparty.resource.demand.dgTools.result.PayResult;
import cn.com.poc.thirdparty.resource.demand.pay.entity.DgtoolsPayOrderEntity;
import cn.com.yict.framemax.core.service.BaseService;

public interface DgtoolsPayOrderService extends BaseService {

    /**
     * 创建付款订单
     *
     * @param convertDto2Entity
     * @return
     */
    DgtoolsPayOrderEntity createPayOrder(DgtoolsPayOrderEntity convertDto2Entity) throws Exception;


    /**
     * 创建付款订单
     *
     * @param convertDto2Entity
     * @param memberId
     * @return
     */
    DgtoolsPayOrderEntity createPayOrder(DgtoolsPayOrderEntity convertDto2Entity, Long memberId) throws Exception;


    /**
     * 更新付款订单明细
     *
     * @param payOrderSn
     * @param description
     * @param retainInformation
     * @return
     * @throws Exception
     */
    DgtoolsPayOrderEntity updatePayOrderDetailInfo(String payOrderSn, String description, String retainInformation) throws Exception;

    /**
     * 通过预付款号查询付款订单
     *
     * @param payOrderSn
     */
    DgtoolsPayOrderEntity findPayOrderByPaySn(String payOrderSn);

    /**
     * 取消付款订单
     *
     * @param payOrderSn
     */
    void changePayOrder2CancelStatus(String payOrderSn);

    /**
     * 改变付款订单到已支付
     *
     * @param payOrderSn
     * @param amount
     */
    void changePayOrder2PaidStatus(String payOrderSn, Integer amount);


    /**
     * 改变付款订单到已支付
     *
     * @param payOrderSn
     * @param amount
     * @param payChannel
     */
    void changePayOrder2PaidStatus(String payOrderSn, Integer amount, String payChannel);

    /**
     * 创建付款单并且支付
     *
     * @param convertDto2Entity
     * @return
     */
    PayResult createPayOrderAndPay(DgtoolsPayOrderEntity convertDto2Entity) throws Exception;

}