package cn.com.yict.framemax.frame.rest.impl;

import cn.com.poc.common.utils.Assert;
import cn.com.yict.framemax.frame.aggregation.ParamLargerModelConfigService;
import cn.com.yict.framemax.frame.entity.LargeModelConfigEntity;
import cn.com.yict.framemax.frame.entity.TimBreEntity;
import cn.com.yict.framemax.frame.rest.LargeModelConfigRest;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.List;

@Component
public class LargeModelConfigRestImpl implements LargeModelConfigRest {

    @Resource
    ParamLargerModelConfigService paramLargerModelConfigService;

    @Override
    public List<String> getLargeModel() throws Exception {
        return paramLargerModelConfigService.getLargeModel();
    }

    @Override
    public LargeModelConfigEntity saveLargeModelConfig(LargeModelConfigEntity largeModelConfigEntity) throws Exception {
        Assert.notNull(largeModelConfigEntity);
        Assert.notNull(largeModelConfigEntity.getParamValue());
        Assert.notNull(largeModelConfigEntity.getTimbreId());
        Assert.notNull(largeModelConfigEntity.getPresencePenalty());
        Assert.notNull(largeModelConfigEntity.getTemperature());
        if(largeModelConfigEntity.getId() == null){
            return paramLargerModelConfigService.save(largeModelConfigEntity);
        }
        return paramLargerModelConfigService.update(largeModelConfigEntity);
    }

    @Override
    public  List<TimBreEntity> getTimBre() throws Exception {
        return paramLargerModelConfigService.getTimBre();
    }

}
