package cn.com.poc.ai_dialogues.rest;

import cn.com.poc.ai_dialogues.dto.AiDialoguesRecordDto;
import cn.com.poc.ai_dialogues.dto.BatchDelAiDialoguesDto;
import cn.com.poc.expose.dto.DialoguesContextDto;
import cn.com.yict.framemax.core.rest.BaseRest;
import cn.com.yict.framemax.web.permission.Access;
import cn.com.yict.framemax.web.permission.Permission;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

@Permission(Access.Safety)
public interface AiDialoguesRest extends BaseRest {

    /**
     * 创建对话
     *
     * @param fileUrl
     * @param type
     * @return
     * @throws Exception
     */
    String create(@RequestParam(required = false) String fileUrl, @RequestParam String type) throws Exception;

    /**
     * 获取对话列表
     */
    List<AiDialoguesRecordDto> getList(@RequestParam String type) throws Exception;


    /**
     * 批量删除对话列表
     */
    void batchDelete(@RequestBody BatchDelAiDialoguesDto dto) throws Exception;

    /**
     * 获取对话详情
     *
     * @param dialoguesId 对话ID
     */
    AiDialoguesRecordDto dialoguesDetail(@RequestParam String dialoguesId) throws Exception;


    /**
     * 获取对话上下文
     */
    List<DialoguesContextDto> getDialogueContext(@RequestParam String dialogueId) throws Exception;
}
