package cn.com.poc.common.service.impl;

import cn.com.poc.common.model.BizFileUploadRecordModel;
import cn.com.poc.common.repository.BizFileUploadRecordRepository;
import cn.com.poc.common.service.BizFileUploadRecordService;
import cn.com.poc.common.utils.StringUtils;
import cn.com.yict.framemax.core.service.impl.BaseServiceImpl;
import cn.com.yict.framemax.data.model.PagingInfo;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Collection;
import java.util.List;

@Service
public class BizFileUploadRecordServiceImpl extends BaseServiceImpl
        implements BizFileUploadRecordService {

    @Resource
    private BizFileUploadRecordRepository repository;

    @Override
    public String getFileNameByFileUrl(String fileUrl) {
        if (StringUtils.isBlank(fileUrl)) {
            return null;
        }
        BizFileUploadRecordModel bizFileUploadRecordModel = new BizFileUploadRecordModel();
        bizFileUploadRecordModel.setFileUrl(fileUrl);
        List<BizFileUploadRecordModel> models = this.repository.findByExample(bizFileUploadRecordModel);

        if (CollectionUtils.isEmpty(models)) {
            return null;
        }
        return models.get(0).getFileName();
    }

    public BizFileUploadRecordModel get(Long id) throws Exception {
        return this.repository.get(id);
    }

    public List<BizFileUploadRecordModel> findByExample(BizFileUploadRecordModel example, PagingInfo pagingInfo) throws Exception {
        if (example == null) {
            example = new BizFileUploadRecordModel();
        }
        return this.repository.findByExample(example, pagingInfo);
    }

    public void delete(BizFileUploadRecordModel model) throws Exception {
        this.repository.remove(model);
    }

    public void deleteById(Long id) throws Exception {
        this.repository.removeByPk(id);
    }

    public void deleteAll(Collection<Long> ids) throws Exception {
        this.repository.removeAllByPk(ids);
    }

    public BizFileUploadRecordModel save(BizFileUploadRecordModel model) {
        return this.repository.save(model);
    }

    public Collection<BizFileUploadRecordModel> saveAll(Collection<BizFileUploadRecordModel> models) throws Exception {
        return this.repository.saveAll(models);
    }
}