package cn.com.poc.data_analyze.model;

import java.io.Serializable;

import cn.com.yict.framemax.data.model.BaseModelClass;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Id;

import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;

/**
 * Model class for biz_data_analyze_dialogue_record
 * 数据分析记录表 - 对话记录表
 */
@Entity
@Table(name = "biz_data_analyze_dialogue_record")
@DynamicInsert
@DynamicUpdate
public class BizDataAnalyzeDialogueRecordModel extends BaseModelClass implements Serializable {

    private static final long serialVersionUID = 1L;


    /**
     * id
     */
    private java.lang.Long id;

    @Column(name = "id", length = 19)
    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    public java.lang.Long getId() {
        return this.id;
    }

    public void setId(java.lang.Long id) {
        this.id = id;
        super.addValidField("id");
    }


    /**
     * relation_id
     * 主体关联id
     */
    private java.lang.String relationId;

    @Column(name = "relation_id", length = 120)
    public java.lang.String getRelationId() {
        return this.relationId;
    }

    public void setRelationId(java.lang.String relationId) {
        this.relationId = relationId;
        super.addValidField("relationId");
    }


    /**
     * type
     * 应用类型  agent-agent应用
     */
    private java.lang.String type;

    @Column(name = "type", length = 15)
    public java.lang.String getType() {
        return this.type;
    }

    public void setType(java.lang.String type) {
        this.type = type;
        super.addValidField("type");
    }


    /**
     * member_id
     * 用户id
     */
    private java.lang.Long memberId;

    @Column(name = "member_id", length = 19)
    public java.lang.Long getMemberId() {
        return this.memberId;
    }

    public void setMemberId(java.lang.Long memberId) {
        this.memberId = memberId;
        super.addValidField("memberId");
    }


    /**
     * channel
     * 使用渠道
     * 应用调式： 调试、多模型调试
     * 使用渠道： 首页、应用广场、链接分享、API调用
     */
    private java.lang.String channel;

    @Column(name = "channel", length = 20)
    public java.lang.String getChannel() {
        return this.channel;
    }

    public void setChannel(java.lang.String channel) {
        this.channel = channel;
        super.addValidField("channel");
    }


    /**
     * datetime
     * 对话上报时间
     */
    private java.util.Date datetime;

    @Column(name = "datetime", length = 19)
    public java.util.Date getDatetime() {
        return this.datetime;
    }

    public void setDatetime(java.util.Date datetime) {
        this.datetime = datetime;
        super.addValidField("datetime");
    }

    /**
     * 积分使用情况   00.00
     */
    private Double pointNum;

    @Column(name = "point_num", length = 19)
    public Double getPointNum() {
        return pointNum;
    }

    public void setPointNum(Double pointNum) {
        this.pointNum = pointNum;
        super.addValidField("pointNum");
    }


}