package cn.com.poc.equity.model;	

import java.io.Serializable;
import cn.com.yict.framemax.data.model.BaseModelClass;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Id;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import javax.persistence.Version;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;

/**
 * Model class for biz_member_equity
 * 用户权益表
保存用户权益等级，
1：相同套餐叠加购买情况   积分和套餐有效期进行叠加，权益不叠加
2： 不同套餐叠加购买情况    积分叠加，权益和时间按照最高级的套餐的权益和有效期
 */
@Entity
@Table(name = "biz_member_equity")
@DynamicInsert
@DynamicUpdate
public class BizMemberEquityModel extends BaseModelClass implements Serializable {

    private static final long serialVersionUID = 1L;
    
  
    /** id
    *主键ID
    */ 
    private java.lang.Long id;
    
    @Column(name = "id",length = 19)
	@Id @GeneratedValue(strategy = GenerationType.AUTO) 
    public java.lang.Long getId(){
        return this.id;
    }
    
    public void setId(java.lang.Long id){
        this.id = id;
        super.addValidField("id");
    }
    
  
    /** member_id
    *用户ID
    */ 
    private java.lang.Long memberId;
    
    @Column(name = "member_id",length = 19)
    public java.lang.Long getMemberId(){
        return this.memberId;
    }
    
    public void setMemberId(java.lang.Long memberId){
        this.memberId = memberId;
        super.addValidField("memberId");
    }
    
  
    /** equity_level
    *权益等级 normal-普通版 professional-专业版 ， ultimate-旗舰版
    */ 
    private java.lang.String equityLevel;
    
    @Column(name = "equity_level",length = 100)
    public java.lang.String getEquityLevel(){
        return this.equityLevel;
    }
    
    public void setEquityLevel(java.lang.String equityLevel){
        this.equityLevel = equityLevel;
        super.addValidField("equityLevel");
    }
    
  
    /** expired_date
    *权益过期时间
    */ 
    private java.util.Date expiredDate;
    
    @Column(name = "expired_date",length = 19)
    public java.util.Date getExpiredDate(){
        return this.expiredDate;
    }
    
    public void setExpiredDate(java.util.Date expiredDate){
        this.expiredDate = expiredDate;
        super.addValidField("expiredDate");
    }
    
  
    /** equity_config
    *权益配置- 知识库最大创建数   应用最大创建数
    */ 
    private java.lang.String equityConfig;
    
    @Column(name = "equity_config",length = 1073741824)
    public java.lang.String getEquityConfig(){
        return this.equityConfig;
    }
    
    public void setEquityConfig(java.lang.String equityConfig){
        this.equityConfig = equityConfig;
        super.addValidField("equityConfig");
    }
    
  
    /** is_deleted
    *是否删除 Y 是  N 否
    */ 
    private java.lang.String isDeleted;
    
    @Column(name = "is_deleted",length = 1)
    public java.lang.String getIsDeleted(){
        return this.isDeleted;
    }
    
    public void setIsDeleted(java.lang.String isDeleted){
        this.isDeleted = isDeleted;
        super.addValidField("isDeleted");
    }
    
  
    /** CREATOR
    *创建人
    */ 
    private java.lang.String creator;
    
    @Column(name = "CREATOR",length = 11)
    public java.lang.String getCreator(){
        return this.creator;
    }
    
    public void setCreator(java.lang.String creator){
        this.creator = creator;
        super.addValidField("creator");
    }
    
  
    /** CREATED_TIME
    *创建时间
    */ 
    private java.util.Date createdTime;
    
    @Column(name = "CREATED_TIME",length = 19)
    public java.util.Date getCreatedTime(){
        return this.createdTime;
    }
    
    public void setCreatedTime(java.util.Date createdTime){
        this.createdTime = createdTime;
        super.addValidField("createdTime");
    }
    
  
    /** MODIFIER
    *修改人
    */ 
    private java.lang.String modifier;
    
    @Column(name = "MODIFIER",length = 11)
    public java.lang.String getModifier(){
        return this.modifier;
    }
    
    public void setModifier(java.lang.String modifier){
        this.modifier = modifier;
        super.addValidField("modifier");
    }
    
  
    /** MODIFIED_TIME
    *修改时间
    */ 
    private java.util.Date modifiedTime;
    
    @Column(name = "MODIFIED_TIME",length = 19)
    public java.util.Date getModifiedTime(){
        return this.modifiedTime;
    }
    
    public void setModifiedTime(java.util.Date modifiedTime){
        this.modifiedTime = modifiedTime;
        super.addValidField("modifiedTime");
    }
    
  
    /** SYS_VERSION
    *乐观锁,版本号
    */ 
    private java.lang.Integer sysVersion;
    
    @Column(name = "SYS_VERSION",length = 10)
	@Version
    public java.lang.Integer getSysVersion(){
        return this.sysVersion;
    }
    
    public void setSysVersion(java.lang.Integer sysVersion){
        this.sysVersion = sysVersion;
        super.addValidField("sysVersion");
    }
    

}