package cn.com.poc.equity.service.impl;

import cn.com.poc.equity.query.QueryPointTransactionHistoryQueryCondition;
import cn.com.poc.equity.query.QueryPointTransactionHistoryQueryItem;
import cn.com.yict.framemax.core.service.impl.BaseServiceImpl;
import cn.com.poc.equity.service.BizMemberPointTransactionHistoryService;
import cn.com.poc.equity.model.BizMemberPointTransactionHistoryModel;
import cn.com.poc.equity.entity.BizMemberPointTransactionHistoryEntity;
import cn.com.poc.equity.convert.BizMemberPointTransactionHistoryConvert;
import cn.com.poc.equity.repository.BizMemberPointTransactionHistoryRepository;
import cn.com.yict.framemax.data.model.PagingInfo;
import org.springframework.stereotype.Service;

import org.apache.commons.collections4.CollectionUtils;

import java.util.ArrayList;
import java.util.stream.Collectors;
import java.util.List;
import javax.annotation.Resource;

import org.springframework.util.Assert;

@Service
public class BizMemberPointTransactionHistoryServiceImpl extends BaseServiceImpl
        implements BizMemberPointTransactionHistoryService {

    @Resource
    private BizMemberPointTransactionHistoryRepository repository;

    public BizMemberPointTransactionHistoryEntity get(java.lang.Long id) throws Exception {
        Assert.notNull(id);
        BizMemberPointTransactionHistoryModel model = this.repository.get(id);
        if (model == null) {
            return null;
        }
        if ("Y".equals(model.getIsDeleted())) {
            return null;
        }
        return BizMemberPointTransactionHistoryConvert.modelToEntity(model);
    }


    public List<BizMemberPointTransactionHistoryEntity> findByExample(BizMemberPointTransactionHistoryEntity example, PagingInfo pagingInfo) throws Exception {
        List<BizMemberPointTransactionHistoryEntity> result = new ArrayList<BizMemberPointTransactionHistoryEntity>();
        BizMemberPointTransactionHistoryModel model = new BizMemberPointTransactionHistoryModel();
        if (example != null) {
            model = BizMemberPointTransactionHistoryConvert.entityToModel(example);
        }
        model.setIsDeleted("N");
        List<BizMemberPointTransactionHistoryModel> models = this.repository.findByExample(model, pagingInfo);
        if (CollectionUtils.isNotEmpty(models)) {
            result = models.stream().map(BizMemberPointTransactionHistoryConvert::modelToEntity).collect(Collectors.toList());
        }
        return result;
    }

    public BizMemberPointTransactionHistoryEntity save(BizMemberPointTransactionHistoryEntity entity) throws Exception {
        Assert.notNull(entity);
        entity.setId(null);
        entity.setIsDeleted("N");
        BizMemberPointTransactionHistoryModel model = BizMemberPointTransactionHistoryConvert.entityToModel(entity);
        BizMemberPointTransactionHistoryModel saveModel = this.repository.save(model);
        return BizMemberPointTransactionHistoryConvert.modelToEntity(saveModel);
    }

    public BizMemberPointTransactionHistoryEntity update(BizMemberPointTransactionHistoryEntity entity) throws Exception {
        Assert.notNull(entity);
        Assert.notNull(entity.getId(), "update pk can not be null");
        BizMemberPointTransactionHistoryModel model = this.repository.get(entity.getId());

        if (entity.getTransactionSn() != null) {
            model.setTransactionSn(entity.getTransactionSn());
        }
        if (entity.getModifyEvent() != null) {
            model.setModifyEvent(entity.getModifyEvent());
        }
        if (entity.getModifyEventInfo() != null) {
            model.setModifyEventInfo(entity.getModifyEventInfo());
        }
        if (entity.getModifyTargetId() != null) {
            model.setModifyTargetId(entity.getModifyTargetId());
        }
        if (entity.getPointChangeNum() != null) {
            model.setPointChangeNum(entity.getPointChangeNum());
        }
        if (entity.getIsDeleted() != null) {
            model.setIsDeleted(entity.getIsDeleted());
        }
        if (entity.getCreator() != null) {
            model.setCreator(entity.getCreator());
        }
        if (entity.getCreatedTime() != null) {
            model.setCreatedTime(entity.getCreatedTime());
        }
        if (entity.getModifier() != null) {
            model.setModifier(entity.getModifier());
        }
        if (entity.getModifiedTime() != null) {
            model.setModifiedTime(entity.getModifiedTime());
        }
        if (entity.getSysVersion() != null) {
            model.setSysVersion(entity.getSysVersion());
        }
        BizMemberPointTransactionHistoryModel saveModel = this.repository.save(model);
        return BizMemberPointTransactionHistoryConvert.modelToEntity(saveModel);
    }

    public void deletedById(java.lang.Long id) throws Exception {
        Assert.notNull(id);
        BizMemberPointTransactionHistoryModel model = this.repository.get(id);
        if (model != null) {
            if ("N".equals(model.getIsDeleted())) {
                model.setIsDeleted("Y");
                this.repository.save(model);
            }
        }
    }


    @Override
    public List<QueryPointTransactionHistoryQueryItem> queryPointTransactionHistory(QueryPointTransactionHistoryQueryCondition condition, PagingInfo pagingInfo) throws Exception {
        return this.sqlDao.query(condition, QueryPointTransactionHistoryQueryItem.class, pagingInfo);
    }
}