package cn.com.poc.knowledge.rest;

import cn.com.poc.knowledge.dto.*;
import cn.com.poc.thirdparty.resource.demand.ai.entity.knowledge.GetKnowledgeChunkInfoResult;
import cn.com.yict.framemax.core.rest.BaseRest;
import cn.com.yict.framemax.data.model.PagingInfo;
import cn.com.yict.framemax.web.permission.Access;
import cn.com.yict.framemax.web.permission.Permission;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;

@Permission(Access.Safety)
public interface KnowledgeRest extends BaseRest {

    /**
     * 上传文档
     *
     * @param documentFiles 文档
     * @param knowledgeType 知识库类型
     * @return 是否成功
     */
    List<BizKnowledgeDocumentDto> uploadDocument(@RequestParam("documentFiles") MultipartFile[] documentFiles, @RequestParam(required = false) String knowledgeType) throws Exception;

    /**
     * 删除文档
     *
     * @param knowledgeInfoId 知识库ID
     * @param kdId            文档ID
     * @return 是否成功
     */
    Boolean delDocument(@RequestParam Integer knowledgeInfoId, @RequestParam Integer kdId);

    /**
     * 批量删除文档
     *
     * @param knowledgeInfoId
     * @param kdId            主键ID
     * @return 是否成功
     */
    Boolean batchDelDocument(@RequestParam Integer knowledgeInfoId, @RequestBody List<Integer> kdId);


    /**
     * 重命名
     */
    Boolean renameDocument(@RequestParam Integer kdId, @RequestParam String rename) throws Exception;

    /**
     * 启用 / 关闭
     */
    String enableKnowledge(@RequestParam Integer kdId) throws Exception;

    /**
     * 开启训练
     */
    Boolean trainKnowledge(@RequestBody TrainKnowledgeDto dto) throws Exception;

    /**
     * 模糊查询知识库文档
     */
    List<BizKnowledgeDocumentDto> searchDocuments(@RequestParam(required = false) String search,
                                                  @RequestParam(required = false) String trainStatus,
                                                  @RequestParam Integer knowledgeInfoId,
                                                  PagingInfo pagingInfo) throws Exception;

    /**
     * 获取知识库的文档列表
     *
     * @param knowledgeInfoId
     * @return
     * @throws Exception
     */
    List<BizKnowledgeDocumentDto> getKdIdsByKnowledgeInfoId(@RequestParam Integer knowledgeInfoId);

    /**
     * 获取知识库的文档列表
     *
     * @param kdIds
     * @return
     * @throws Exception
     */
    List<BizKnowledgeDocumentDto> getListByKdIds(@RequestBody List<Integer> kdIds);

    /**
     * 获取知识库详情
     */
    BizKnowledgeInfoDto getKnowledgeDetail(@RequestParam Integer knowledgeInfoId) ;

    /**
     * 获取用户知识库列表
     *
     * @param search      搜索条件
     * @param trainStatus 训练状态
     */
    List<QueryKnowledgeDocumentDto> getKnowledgeList(@RequestParam(required = false) String search, @RequestParam(required = false) String trainStatus, PagingInfo pagingInfo) throws Exception;

    /**
     * 获取用户知识库列表
     *
     * @param knowledgeInfoIds 知识库ID
     */
    List<QueryKnowledgeDocumentDto> getKnowledgeListByKnowledgeInfoIds(@RequestBody List<Integer> knowledgeInfoIds) throws Exception;

    /**
     * 创建知识库
     */
    BizKnowledgeInfoDto createKnowledge(@RequestBody BizKnowledgeInfoDto dto) throws Exception;

    /**
     * 更新知识库
     */
    BizKnowledgeInfoDto updateKnowledgeInfo(@RequestBody BizKnowledgeInfoDto dto) throws Exception;

    /**
     * 开启关闭知识库
     */
    void enableKnowledgeInfo(@RequestParam Integer knowledgeInfoId, @RequestParam String isOpen) throws Exception;

    /**
     * 删除知识库
     */
    void deleteKnowledgeInfo(@RequestParam Integer knowledgeInfoId) throws Exception;

    /**
     * 开关知识库分片
     */
    void openKnowledgeChunk(@RequestBody UpsertChunkInfoDto dto);

    /**
     * 删除知识库分片
     */
    void deleteKnowledgeChunk(@RequestBody UpsertChunkInfoDto dto);

    /**
     * 更新知识库分片内容
     */
    void updateKnowledgeChunkDoc(@RequestBody UpsertChunkInfoDto dto);

    /**
     * 新增知识库分片
     */
    void addKnowledgeChunk(@RequestBody UpsertChunkInfoDto dto);

    /**
     * 获取知识库分片信息
     */
    GetKnowledgeChunkInfoResult getChunks(@RequestParam List<Integer> kdIds, @RequestParam String query, PagingInfo pagingInfo);
}