package cn.com.poc.knowledge.rest.impl;

import cn.com.poc.common.annotation.RedisLimit;
import cn.com.poc.knowledge.aggregate.QAKnowledgeService;
import cn.com.poc.knowledge.convert.QAKnowledgeChunkConvert;
import cn.com.poc.knowledge.dto.QAKnowledgeChunkDto;
import cn.com.poc.knowledge.dto.QAKnowledgeStructDto;
import cn.com.poc.knowledge.dto.UpsertChunkInfoDto;
import cn.com.poc.knowledge.rest.QAKnowledgeRest;
import cn.com.poc.thirdparty.resource.demand.ai.entity.qaknowledge.QAKnowledgeChunkResult;
import cn.com.poc.thirdparty.resource.demand.ai.entity.qaknowledge.QAKnowledgeConfig;
import cn.com.poc.thirdparty.resource.demand.ai.entity.qaknowledge.QAKnowledgeStructResult;
import cn.com.yict.framemax.data.model.PagingInfo;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.List;

/**
 * @author alex.yao
 * @date 2025/2/26
 */
@Component
public class QAKnowledgeRestImpl implements QAKnowledgeRest {

    @Resource
    private QAKnowledgeService qaKnowledgeService;

    @Override
    @RedisLimit(key = "OPEN_KNOWLEDGE_CHUNK", timeout = 1, currentUser = true, count = 1)
    public void openKnowledgeChunk(UpsertChunkInfoDto dto) {
        qaKnowledgeService.openKnowledgeChunk(dto.getKdId(), dto.getChunkRelationId(), dto.getIsOpen());
    }

    @Override
    @RedisLimit(key = "DELETE_KNOWLEDGE_CHUNK", timeout = 1, currentUser = true, count = 1)
    public void deleteKnowledgeChunk(UpsertChunkInfoDto dto) {
        qaKnowledgeService.deleteKnowledgeChunk(dto.getKdId(), dto.getChunkRelationId());
    }

    @Override
    @RedisLimit(key = "UPDATE_KNOWLEDGE_CHUNK_DOC", timeout = 1, currentUser = true, count = 1)
    public void updateKnowledgeChunkDoc(UpsertChunkInfoDto dto) {
        qaKnowledgeService.updateKnowledgeChunkDoc(dto.getKdId(), dto.getChunkRelationId(), dto.getStructId(), dto.getChunkContent());
    }

    @Override
    @RedisLimit(key = "BATCH_UPDATE_KNOWLEDGE_CHUNK_DOC", timeout = 1, currentUser = true, count = 1)
    public void batchUpdateKnowledgeChunkDoc(UpsertChunkInfoDto dto) {
        qaKnowledgeService.updateKnowledgeChunkDoc(dto.getKdId(), dto.getChunkRelationId(), dto.getChunkInfos());
    }

    @Override
    @RedisLimit(key = "ADD_KNOWLEDGE_CHUNK", timeout = 1, currentUser = true, count = 1)
    public void addKnowledgeChunk(UpsertChunkInfoDto dto) {
        qaKnowledgeService.addKnowledgeChunk(dto.getKdId(), dto.getChunkInfos(), dto.getChunkSort());
    }

    @Override
    public QAKnowledgeChunkDto getQAKnowledgeChunks(Integer kdId, String query, PagingInfo pagingInfo) {
        return QAKnowledgeChunkConvert.result2Dto(qaKnowledgeService.getChunkInfo(kdId, query, pagingInfo));
    }

    @Override
    @RedisLimit(key = "UPDATE_KNOWLEDGE_CHUNK", timeout = 1, currentUser = true, count = 1)
    public void updateKnowledgeChunk(Integer kdId, Long structId, String structName, String isIndex) {
        qaKnowledgeService.updateKnowledgeStruct(kdId, structId, structName, isIndex);
    }

    @Override
    @RedisLimit(key = "OPEN_KNOWLEDGE_CHUNK", timeout = 1, currentUser = true, count = 1)
    public void batchDeleteKnowledgeChunks(Integer kdId, List<String> chunkRelationIds) {
        qaKnowledgeService.batchDeleteKnowledgeChunk(kdId, chunkRelationIds);
    }

    @Override
    @RedisLimit(key = "OPEN_KNOWLEDGE_CHUNK", timeout = 1, currentUser = true, count = 1)
    public void updateChunkSort(Integer kdId, String chunkRelationId, Integer sort) {
        qaKnowledgeService.updateKnowledgeChunkSort(kdId, chunkRelationId, sort);
    }

    @Override
    public QAKnowledgeStructDto getKnowledgeStruct(Integer kdId) {
        QAKnowledgeStructResult knowledgeStruct = qaKnowledgeService.getKnowledgeStruct(kdId);
        QAKnowledgeStructDto dto = new QAKnowledgeStructDto();
        dto.setKey(knowledgeStruct.getKey());
        return dto;
    }
}
