package cn.com.poc.long_document.model;

import cn.com.yict.framemax.data.model.BaseModelClass;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.*;
import java.io.Serializable;

/**
 * Model class for biz_long_text_dialogues
 * 长文文档
 */
@Entity
@Table(name = "biz_long_text_dialogues")
@DynamicInsert
@DynamicUpdate
public class BizLongTextDialoguesModel extends BaseModelClass implements Serializable {

    private static final long serialVersionUID = 1L;
    
  
    /** id
    *
    */ 
    private Long id;
    
    @Column(name = "id",length = 19)
	@Id @GeneratedValue(strategy = GenerationType.AUTO) 
    public Long getId(){
        return this.id;
    }
    
    public void setId(Long id){
        this.id = id;
        super.addValidField("id");
    }



    /** title
     *title
     */
    private String title;

    @Column(name = "title",length = 150)
    public String getTitle(){
        return this.title;
    }

    public void setTitle(String title){
        this.title = title;
        super.addValidField("title");
    }
    
  
    /** dialogs_id
    *对话id
    */ 
    private String dialogsId;
    
    @Column(name = "dialogs_id",length = 100)
    public String getDialogsId(){
        return this.dialogsId;
    }
    
    public void setDialogsId(String dialogsId){
        this.dialogsId = dialogsId;
        super.addValidField("dialogsId");
    }
    
  
    /** member_id
    *用户
    */ 
    private Long memberId;
    
    @Column(name = "member_id",length = 100)
    public Long getMemberId(){
        return this.memberId;
    }
    
    public void setMemberId(Long memberId){
        this.memberId = memberId;
        super.addValidField("memberId");
    }
    
  
    /** file_url
    *文件地址
    */ 
    private String fileUrl;
    
    @Column(name = "file_url",length = 150)
    public String getFileUrl(){
        return this.fileUrl;
    }
    
    public void setFileUrl(String fileUrl){
        this.fileUrl = fileUrl;
        super.addValidField("fileUrl");
    }
    
  
    /** is_deleted
    *是否删除 1、Y 是 2、N 否
    */ 
    private String isDeleted;
    
    @Column(name = "is_deleted",length = 1)
    public String getIsDeleted(){
        return this.isDeleted;
    }
    
    public void setIsDeleted(String isDeleted){
        this.isDeleted = isDeleted;
        super.addValidField("isDeleted");
    }
    
  
    /** CREATOR
    *创建人
    */ 
    private String creator;
    
    @Column(name = "CREATOR",length = 225)
    public String getCreator(){
        return this.creator;
    }
    
    public void setCreator(String creator){
        this.creator = creator;
        super.addValidField("creator");
    }
    
  
    /** CREATED_TIME
    *创建时间
    */ 
    private java.util.Date createdTime;
    
    @Column(name = "CREATED_TIME",length = 19)
    public java.util.Date getCreatedTime(){
        return this.createdTime;
    }
    
    public void setCreatedTime(java.util.Date createdTime){
        this.createdTime = createdTime;
        super.addValidField("createdTime");
    }
    
  
    /** MODIFIER
    *修改人
    */ 
    private String modifier;
    
    @Column(name = "MODIFIER",length = 225)
    public String getModifier(){
        return this.modifier;
    }
    
    public void setModifier(String modifier){
        this.modifier = modifier;
        super.addValidField("modifier");
    }
    
  
    /** MODIFIED_TIME
    *修改时间
    */ 
    private java.util.Date modifiedTime;
    
    @Column(name = "MODIFIED_TIME",length = 19)
    public java.util.Date getModifiedTime(){
        return this.modifiedTime;
    }
    
    public void setModifiedTime(java.util.Date modifiedTime){
        this.modifiedTime = modifiedTime;
        super.addValidField("modifiedTime");
    }
    
  
    /** SYS_VERSION
    *乐观锁,版本号
    */ 
    private Integer sysVersion;
    
    @Column(name = "SYS_VERSION",length = 10)
	@Version
    public Integer getSysVersion(){
        return this.sysVersion;
    }
    
    public void setSysVersion(Integer sysVersion){
        this.sysVersion = sysVersion;
        super.addValidField("sysVersion");
    }
    

}