package cn.com.poc.thirdparty.resource.demand.ai.function.long_memory;

import cn.com.poc.agent_application.entity.KnowledgeContentResult;
import cn.com.poc.agent_application.entity.Variable;
import cn.com.poc.common.service.RedisService;
import cn.com.poc.common.utils.DateUtils;
import cn.com.poc.common.utils.JsonUtils;
import cn.com.poc.thirdparty.resource.demand.ai.entity.dbchain.DBChainResult;
import cn.com.poc.thirdparty.resource.demand.ai.function.AbstractFunctionResult;
import cn.com.poc.thirdparty.resource.demand.ai.function.AbstractLargeModelFunction;
import cn.com.poc.thirdparty.resource.demand.ai.function.entity.FunctionLLMConfig;
import cn.com.poc.thirdparty.resource.demand.ai.function.entity.Parameters;
import cn.com.poc.thirdparty.resource.demand.ai.function.entity.Properties;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.json.JSONObject;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.List;

/**
 * 长期记忆
 */

@Component
public class SetLongMemoryFunction extends AbstractLargeModelFunction {

    private final String desc = "该方法仅用来保存用户想记录的内容，不能通过该方法进行查询。";

    private final FunctionLLMConfig functionLLMConfig = new FunctionLLMConfig.FunctionLLMConfigBuilder()
            .name("set_long_memory")
            .description(desc)
            .parameters(new Parameters("object").addProperties("content", new Properties("string", "内容的详细说明")))
            .build();

    @Resource
    private RedisService redisService;

    @Override
    public String getDesc() {
        return desc;
    }

    /**
     * 执行函数
     *
     * @param content                 内容
     * @param key                     唯一标识
     * @param dbChainResults
     * @param knowledgeContentResults
     * @return
     */
    @Override
    public AbstractFunctionResult<String> doFunction(String content, String key, List<DBChainResult> dbChainResults, List<KnowledgeContentResult> knowledgeContentResults) {
        // 创建 JSONObject 对象
        JSONObject contentJsonObject = new JSONObject(content);
        // 提取 content
        String contents = contentJsonObject.getStr("content");
        String contentKey = SetLongMemoryConstants.REDIS_PREFIX + key;
        redisService.hset(contentKey, DateUtils.getCurrTime(), contents);

        AbstractFunctionResult<String> result = new AbstractFunctionResult<>();
        result.setFunctionResult("SUCCESS");
        result.setPromptContent("SUCCESS");
        return result;
    }

    @Override
    public List<String> getLLMConfig() {
        return ListUtil.toList(JsonUtils.serialize(functionLLMConfig));
    }

    @Override
    public List<String> getLLMConfig(List<Variable> variableStructure) {
        return this.getLLMConfig();
    }

}
