package cn.com.poc.thirdparty.resource.demand.ai.function;

import cn.com.poc.agent_application.entity.Variable;
import cn.com.poc.thirdparty.resource.demand.ai.function.document_understanding.DocumentUnderstandIngFunction;
import cn.com.yict.framemax.core.spring.SingleContextInitializer;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.web.WebAppConfiguration;

import javax.annotation.Resource;
import java.util.List;
import java.util.UUID;

@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration(initializers = SingleContextInitializer.class)
@WebAppConfiguration
public class DocumentUnderstandingFunctionTest {

    @Resource
    DocumentUnderstandIngFunction documentUnderstandIngFunction;

    @Test
    public void testDoFunction() {
        String content = "{\"file_url\": \"https://gsst-poe-sit.gz.bcebos.com/data/20250410/1744277235901.pdf\",\"question\":\"Can a registered Grade C electrical worker work on the electrical work of a Grade A electrical worker?\"}";
        String identifier = UUID.randomUUID().toString();
        AbstractFunctionResult<String> result = documentUnderstandIngFunction.doFunction(content, identifier, null, null);
        System.out.println(result.getFunctionResult());
    }

    @Test
    public void testGetDesc() {
        System.out.println(documentUnderstandIngFunction.getDesc());
    }

    @Test
    public void testGetLLMConfig() {
        System.out.println(documentUnderstandIngFunction.getLLMConfig());
    }

    @Test
    public void testGetLLMConfigToVariableStructure() {
        List<Variable> variableStructure = Mockito.mock(List.class);
        System.out.println(documentUnderstandIngFunction.getLLMConfig(variableStructure));
    }
}
