package cn.com.poc.thirdparty.resource.demand.ai.function;

import cn.com.poc.thirdparty.resource.demand.ai.function.extraction.ContractExtractionFunction;
import cn.com.poc.thirdparty.resource.textin.api.TextInClient;
import cn.com.yict.framemax.core.spring.SingleContextInitializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.junit.runner.RunWith;
import org.junit.Test;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.web.WebAppConfiguration;

import javax.annotation.Resource;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;

/**
 * @author alex.yao
 * @date 2025/5/7
 */
@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration(initializers = SingleContextInitializer.class)
@WebAppConfiguration
public class PdfToMdFunctionTest {

    @Test
    public void test_pdfToMd() {
        String url = "https://gsst-poe-sit.gz.bcebos.com/v1/1f606155c112a421bfa818e8d89b9ee%281%29.jpg?authorization=bce-auth-v1%2Fae40d293ec92452789c8f0c25a3d4e32%2F2025-05-07T06%3A51%3A07Z%2F300%2Fhost%2F7a55d6672fddf9ba7d47bac62d7dc9e597eaa0fb52c959cb3953c05371d37065";

        byte[] fileContent = url.getBytes(StandardCharsets.UTF_8);
        HashMap<String, Object> options = new HashMap<>();
        options.put("apply_document_tree", 1);
        options.put("catalog_details", 1);
        options.put("dpi", 144);
        options.put("get_excel", 1);
        options.put("get_image", "objects");
        options.put("markdown_details", 1);
        options.put("page_start", 1);
        options.put("page_count", 1);
        options.put("page_details", 1);
        options.put("paratext_mode", "annotation");
        options.put("parse_mode", "auto");
        options.put("table_flavor", "md");
        try {
            TextInClient textInClient = new TextInClient();
            String response = textInClient.OCR(fileContent, options);
            ObjectMapper mapper = new ObjectMapper();
            JsonNode jsonNode = mapper.readTree(response);
            if (jsonNode.has("result") && jsonNode.get("result").has("markdown")) {
                String markdown = jsonNode.get("result").get("markdown").asText();
                System.out.println(markdown);
            } else {
                System.out.println(response);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Resource
    private ContractExtractionFunction contractExtractionFunction;

    @Test
    public void test_cefunction() {
        System.out.println(contractExtractionFunction.getLLMConfig());

    }
}
