package cn.com.poc.utils;

import cn.com.poc.common.utils.DocumentLoad;
import cn.com.poc.common.utils.FileUtils;
import cn.com.yict.framemax.core.spring.SingleContextInitializer;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.text.PDFTextStripper;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringJUnit4ClassRunner;
import org.springframework.test.context.web.WebAppConfiguration;

import java.io.*;

/**
 * @author alex.yao
 * @date 2025/6/12
 */
@RunWith(SpringJUnit4ClassRunner.class)
@ContextConfiguration(initializers = SingleContextInitializer.class)
@WebAppConfiguration
public class FileUtilsTest {


    @Test
    public void test_wordConvertPDF() throws Exception {

    }


    @Test
    public void test_pdf2word() {
        try {
            String pdfFile = "C:\\Users\\52747\\Documents\\dataset\\EMSD_Regulatory_Services_Handbook_LPG16.pdf";
            String wordFile = "C:\\Users\\52747\\Documents\\dataset\\EMSD_Regulatory_Services_Handbook_LPG16.doc";

            // 加载PDF文档
            PDDocument pdfDoc = PDDocument.load(new File(pdfFile));
            int totalPages = pdfDoc.getNumberOfPages();

            // 使用追加模式打开Word文件
            try (Writer writer = new OutputStreamWriter(new FileOutputStream(wordFile, true), "UTF-8")) {
                PDFTextStripper stripper = new PDFTextStripper();
                stripper.setSortByPosition(true);
                for (int i = 1; i <= totalPages; i++) {
                    stripper.setStartPage(i);
                    stripper.setEndPage(i);
                    String pageText = stripper.getText(pdfDoc);

                    // 追加当前页内容
                    writer.write(pageText);
                    writer.write("\f");
                }
            }
            pdfDoc.close();
            System.out.println("总计追加 " + totalPages + " 页到现有文件");
        } catch (IOException e) {
            System.err.println("转换失败：" + e.getMessage());
            e.printStackTrace();
        }
    }

}
