package cn.com.poc.data_analyze.constants;

import cn.com.yict.framemax.core.i18n.I18nMessageException;

/**
 * 应用数据分析-时间范围枚举
 *
 * @author alex.yao
 * @date 2024/12/11
 */
public enum DataAnalyzeTimeRangeEnum {
    customize("customize"),
    week("week"),
    month("month"),
    ;

    private String type;

    DataAnalyzeTimeRangeEnum(String type) {
        this.type = type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return type;
    }

    public static DataAnalyzeTimeRangeEnum getByType(String type) {
        for (DataAnalyzeTimeRangeEnum item : values()){
            if (item.getType().equals(type)) {
                return item;
            }
        }
        throw new I18nMessageException("data-analyze/not.support.rang.type");
    }

}
