package cn.com.poc.data_analyze.service.impl;

import cn.com.poc.data_analyze.query.*;
import cn.com.yict.framemax.core.service.impl.BaseServiceImpl;
import cn.com.poc.data_analyze.service.BizDataAnalyzeDialogueRecordService;
import cn.com.poc.data_analyze.model.BizDataAnalyzeDialogueRecordModel;
import cn.com.poc.data_analyze.entity.BizDataAnalyzeDialogueRecordEntity;
import cn.com.poc.data_analyze.convert.BizDataAnalyzeDialogueRecordConvert;
import cn.com.poc.data_analyze.repository.BizDataAnalyzeDialogueRecordRepository;
import cn.com.yict.framemax.data.model.PagingInfo;
import org.springframework.stereotype.Service;

import org.apache.commons.collections4.CollectionUtils;

import java.util.ArrayList;
import java.util.stream.Collectors;
import java.util.List;
import javax.annotation.Resource;

import org.springframework.util.Assert;

@Service
public class BizDataAnalyzeDialogueRecordServiceImpl extends BaseServiceImpl
        implements BizDataAnalyzeDialogueRecordService {

    @Resource
    private BizDataAnalyzeDialogueRecordRepository repository;

    public BizDataAnalyzeDialogueRecordEntity get(java.lang.Long id) throws Exception {
        Assert.notNull(id);
        BizDataAnalyzeDialogueRecordModel model = this.repository.get(id);
        if (model == null) {
            return null;
        }
        return BizDataAnalyzeDialogueRecordConvert.modelToEntity(model);
    }


    public List<BizDataAnalyzeDialogueRecordEntity> findByExample(BizDataAnalyzeDialogueRecordEntity example, PagingInfo pagingInfo) throws Exception {
        List<BizDataAnalyzeDialogueRecordEntity> result = new ArrayList<BizDataAnalyzeDialogueRecordEntity>();
        BizDataAnalyzeDialogueRecordModel model = new BizDataAnalyzeDialogueRecordModel();
        if (example != null) {
            model = BizDataAnalyzeDialogueRecordConvert.entityToModel(example);
        }
        List<BizDataAnalyzeDialogueRecordModel> models = this.repository.findByExample(model, pagingInfo);
        if (CollectionUtils.isNotEmpty(models)) {
            result = models.stream().map(BizDataAnalyzeDialogueRecordConvert::modelToEntity).collect(Collectors.toList());
        }
        return result;
    }

    public BizDataAnalyzeDialogueRecordEntity save(BizDataAnalyzeDialogueRecordEntity entity) throws Exception {
        Assert.notNull(entity);
        entity.setId(null);
        BizDataAnalyzeDialogueRecordModel model = BizDataAnalyzeDialogueRecordConvert.entityToModel(entity);
        BizDataAnalyzeDialogueRecordModel saveModel = this.repository.save(model);
        return BizDataAnalyzeDialogueRecordConvert.modelToEntity(saveModel);
    }

    public BizDataAnalyzeDialogueRecordEntity update(BizDataAnalyzeDialogueRecordEntity entity) throws Exception {
        Assert.notNull(entity);
        Assert.notNull(entity.getId(), "update pk can not be null");
        BizDataAnalyzeDialogueRecordModel model = this.repository.get(entity.getId());

        if (entity.getRelationId() != null) {
            model.setRelationId(entity.getRelationId());
        }
        if (entity.getType() != null) {
            model.setType(entity.getType());
        }
        if (entity.getMemberId() != null) {
            model.setMemberId(entity.getMemberId());
        }
        if (entity.getChannel() != null) {
            model.setChannel(entity.getChannel());
        }
        if (entity.getDatetime() != null) {
            model.setDatetime(entity.getDatetime());
        }
        BizDataAnalyzeDialogueRecordModel saveModel = this.repository.save(model);
        return BizDataAnalyzeDialogueRecordConvert.modelToEntity(saveModel);
    }

    public void deletedById(java.lang.Long id) throws Exception {
        Assert.notNull(id);
        BizDataAnalyzeDialogueRecordModel model = this.repository.get(id);
        if (model != null) {
        }
    }

    @Override
    public List<AgentUsageQueryItem> agentUsageQuery(AgentUsageQueryCondition condition, PagingInfo pagingInfo) {
        return this.sqlDao.query(condition, AgentUsageQueryItem.class, pagingInfo);
    }

    @Override
    public List<AgentDataTrendQueryItem> agentDataTrendQuery(AgentDataTrendQueryCondition condition, PagingInfo pagingInfo) {
        Assert.notNull(condition);
        Assert.notNull(condition.getStartDate());
        Assert.notNull(condition.getEndDate());
        Assert.notNull(condition.getRelationId());
        return this.sqlDao.query(condition, AgentDataTrendQueryItem.class, pagingInfo);
    }

    @Override
    public List<ChannelUserCountQueryItem> channelUserCountQuery(ChannelUserCountQueryCondition condition, PagingInfo pagingInfo) {
        return this.sqlDao.query(condition, ChannelUserCountQueryItem.class, pagingInfo);
    }

    @Override
    public List<ChannelUsageCountQueryItem> channelUsageCountQuery(ChannelUsageCountQueryCondition condition, PagingInfo pagingInfo) {
        return this.sqlDao.query(condition, ChannelUsageCountQueryItem.class, pagingInfo);
    }
}