package cn.com.poc.data_analyze.service.impl;

import cn.com.poc.data_analyze.convert.BizDataAnalyzePointRecordConvert;
import cn.com.poc.data_analyze.entity.BizDataAnalyzePointRecordEntity;
import cn.com.poc.data_analyze.model.BizDataAnalyzePointRecordModel;
import cn.com.poc.data_analyze.query.ChannelPointsCountQueryCondition;
import cn.com.poc.data_analyze.query.ChannelPointsCountQueryItem;
import cn.com.poc.data_analyze.query.PointsUsageQueryCondition;
import cn.com.poc.data_analyze.query.PointsUsageQueryItem;
import cn.com.poc.data_analyze.repository.BizDataAnalyzePointRecordRepository;
import cn.com.poc.data_analyze.service.BizDataAnalyzePointRecordService;
import cn.com.yict.framemax.core.service.impl.BaseServiceImpl;
import cn.com.yict.framemax.data.model.PagingInfo;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

@Service
public class BizDataAnalyzePointRecordServiceImpl extends BaseServiceImpl
        implements BizDataAnalyzePointRecordService {

    @Resource
    private BizDataAnalyzePointRecordRepository repository;

    public BizDataAnalyzePointRecordEntity get(java.lang.Long id) throws Exception {
        Assert.notNull(id);
        BizDataAnalyzePointRecordModel model = this.repository.get(id);
        if (model == null) {
            return null;
        }
        return BizDataAnalyzePointRecordConvert.modelToEntity(model);
    }


    public List<BizDataAnalyzePointRecordEntity> findByExample(BizDataAnalyzePointRecordEntity example, PagingInfo pagingInfo) throws Exception {
        List<BizDataAnalyzePointRecordEntity> result = new ArrayList<BizDataAnalyzePointRecordEntity>();
        BizDataAnalyzePointRecordModel model = new BizDataAnalyzePointRecordModel();
        if (example != null) {
            model = BizDataAnalyzePointRecordConvert.entityToModel(example);
        }
        List<BizDataAnalyzePointRecordModel> models = this.repository.findByExample(model, pagingInfo);
        if (CollectionUtils.isNotEmpty(models)) {
            result = models.stream().map(BizDataAnalyzePointRecordConvert::modelToEntity).collect(Collectors.toList());
        }
        return result;
    }

    public BizDataAnalyzePointRecordEntity save(BizDataAnalyzePointRecordEntity entity) throws Exception {
        Assert.notNull(entity);
        entity.setId(null);
        BizDataAnalyzePointRecordModel model = BizDataAnalyzePointRecordConvert.entityToModel(entity);
        BizDataAnalyzePointRecordModel saveModel = this.repository.save(model);
        return BizDataAnalyzePointRecordConvert.modelToEntity(saveModel);
    }

    public BizDataAnalyzePointRecordEntity update(BizDataAnalyzePointRecordEntity entity) throws Exception {
        Assert.notNull(entity);
        Assert.notNull(entity.getId(), "update pk can not be null");
        BizDataAnalyzePointRecordModel model = this.repository.get(entity.getId());

        if (entity.getRelationId() != null) {
            model.setRelationId(entity.getRelationId());
        }
        if (entity.getType() != null) {
            model.setType(entity.getType());
        }
        if (entity.getMemberId() != null) {
            model.setMemberId(entity.getMemberId());
        }
        if (entity.getPointNum() != null) {
            model.setPointNum(entity.getPointNum());
        }
        if (entity.getChannel() != null) {
            model.setChannel(entity.getChannel());
        }
        if (entity.getDatetime() != null) {
            model.setDatetime(entity.getDatetime());
        }
        BizDataAnalyzePointRecordModel saveModel = this.repository.save(model);
        return BizDataAnalyzePointRecordConvert.modelToEntity(saveModel);
    }

    public void deletedById(java.lang.Long id) throws Exception {
        Assert.notNull(id);
        BizDataAnalyzePointRecordModel model = this.repository.get(id);
        if (model != null) {
        }
    }

    @Override
    public List<PointsUsageQueryItem> pointsUsageQuery(PointsUsageQueryCondition condition, PagingInfo pagingInfo) {
        return this.sqlDao.query(condition, PointsUsageQueryItem.class, pagingInfo);
    }

    @Override
    public List<ChannelPointsCountQueryItem> channelPointsCountQuery(ChannelPointsCountQueryCondition condition, PagingInfo pagingInfo) {
        return this.sqlDao.query(condition, ChannelPointsCountQueryItem.class, pagingInfo);
    }
}