package cn.com.poc.message.service.impl;


import cn.com.poc.common.constant.CommonConstant;
import cn.com.poc.common.utils.Assert;
import cn.com.poc.common.utils.JsonUtils;
import cn.com.poc.knowledge.constant.KnowledgeConstant;
import cn.com.poc.knowledge.entity.BizKnowledgeDocumentEntity;
import cn.com.poc.knowledge.entity.BizKnowledgeInfoEntity;
import cn.com.poc.knowledge.entity.BizKnowledgeTrainLogEntity;
import cn.com.poc.knowledge.service.BizKnowledgeDocumentService;
import cn.com.poc.knowledge.service.BizKnowledgeInfoService;
import cn.com.poc.knowledge.service.BizKnowledgeTrainLogService;
import cn.com.poc.message.entity.KnowledgeTrainStatusMessage;
import cn.com.poc.message.entity.TrainKnowledgeMessage;
import cn.com.poc.message.service.KnowledgeConsumerService;
import cn.com.poc.message.service.KnowledgeProducerService;
import cn.com.poc.message.topic.KnowledgeTopic;
import cn.com.poc.thirdparty.resource.demand.ai.aggregate.DemandKnowledgeService;
import cn.com.poc.thirdparty.resource.demand.ai.constants.KnowledgeTrainStatusConstant;
import cn.com.yict.framemax.core.i18n.I18nMessageException;
import cn.com.yict.framemax.tumbleweed.client.annotation.Consumer;
import com.alibaba.fastjson.TypeReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.parameters.P;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;


@Service
public class KnowledgeConsumerServiceImpl implements KnowledgeConsumerService {

    final private Logger logger = LoggerFactory.getLogger(KnowledgeConsumerService.class);

    @Resource
    private BizKnowledgeTrainLogService bizKnowledgeTrainLogService;

    @Resource
    private BizKnowledgeDocumentService bizKnowledgeDocumentService;

    @Resource
    private DemandKnowledgeService demandKnowledgeService;

    @Resource
    private KnowledgeProducerService knowledgeProducerService;

    @Resource
    private BizKnowledgeInfoService bizKnowledgeInfoService;


    @Override
    @Consumer(topic = KnowledgeTopic.TRAIN_KNOWLEDGE, scale = 3, retry = true)
    public void trainKnowledge(TrainKnowledgeMessage message) throws Exception {
        //修改训练状态
        String knowledgeId = demandKnowledgeService.trainKnowledgeEvent(message.getFileUrl(), message.getSegmentationConfig());
        KnowledgeTrainStatusMessage trainStatusMessage = new KnowledgeTrainStatusMessage();
        trainStatusMessage.setStatus(KnowledgeConstant.TrainStatus.TRAINING);
        trainStatusMessage.setKdId(message.getKid());
        trainStatusMessage.setKnowledgeInfoId(message.getKnowledgeInfoId());
        trainStatusMessage.setKnowledgeId(knowledgeId);
        knowledgeProducerService.trainStatusUpdate(trainStatusMessage);
    }


    @Override
    @Consumer(topic = KnowledgeTopic.TRAIN_STATUS, scale = 1, retry = true)
    public void trainStatusUpdate(KnowledgeTrainStatusMessage message) throws Exception {
        BizKnowledgeDocumentEntity bizKnowledgeDocumentEntity = new BizKnowledgeDocumentEntity();
        bizKnowledgeDocumentEntity.setTrainStatus(message.getStatus());
        bizKnowledgeDocumentEntity.setKnowledgeId(message.getKnowledgeId());
        bizKnowledgeDocumentService.update(message.getKdId(), bizKnowledgeDocumentEntity);
    }


    @Override
    @Consumer(topic = KnowledgeTopic.KNOWLEDGE_INFO_STATUS_CHECK, scale = 3, retry = true)
    public void knowledgeInfoStatusCheck(KnowledgeTrainStatusMessage knowledgeTrainStatusMessage) throws Exception {
        Assert.notNull(knowledgeTrainStatusMessage.getKnowledgeInfoId());
        BizKnowledgeInfoEntity bizKnowledgeInfoEntity = bizKnowledgeInfoService.get(knowledgeTrainStatusMessage.getKnowledgeInfoId());
        if (!KnowledgeConstant.TrainStatus.TRAINING.equals(bizKnowledgeInfoEntity.getTrainStatus())) {
            return;
        }

        String kdIds = bizKnowledgeInfoEntity.getKdIds();
        List<Integer> kdIdList = JsonUtils.deSerialize(kdIds, new TypeReference<List<Integer>>() {
        }.getType());

        boolean isAllComplete = true;
        logger.info("-------知识库训练状态检查，kdIds:{}-------", kdIds);
        for (Integer kdId : kdIdList) {
            BizKnowledgeDocumentEntity documentEntity = bizKnowledgeDocumentService.get(kdId);
            if (KnowledgeConstant.TrainStatus.FAIL.equals(documentEntity.getTrainStatus())) {
                bizKnowledgeInfoEntity.setTrainStatus(KnowledgeConstant.TrainStatus.FAIL);
                bizKnowledgeInfoService.update(bizKnowledgeInfoEntity);
            }

            if (!documentEntity.getTrainStatus().equals(KnowledgeConstant.TrainStatus.COMPLETE)) {
                isAllComplete = false;
                break;
            }
        }
        if (isAllComplete) {
            logger.info("-------知识库训练状态检查，全部完成, knowledgeInfoId:{}-------", knowledgeTrainStatusMessage.getKnowledgeInfoId());
            bizKnowledgeInfoEntity.setTrainStatus(KnowledgeConstant.TrainStatus.COMPLETE);
            bizKnowledgeInfoService.update(bizKnowledgeInfoEntity);
        }
    }
}
