package cn.com.poc.thirdparty.resource.demand.ai.function.entity;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;

import java.util.List;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown = true)
public class Properties {

    private String type;

    private String description;

    @JsonAlias("enum")
    private List<String> enums;

    public Properties(String type, String description) {
        this.type = type;
        this.description = description;
    }

    public Properties(String type, String description, List<String> enums) {
        this.type = type;
        this.description = description;
        this.enums = enums;
    }


    public String getType() {
        return type;
    }

    public String getDescription() {
        return description;
    }

    public List<String> getEnums() {
        return enums;
    }
}
