package cn.com.poc.thirdparty.resource.demand.pay.convert;


import cn.com.poc.common.utils.JsonUtils;
import cn.com.poc.common.utils.StringUtils;
import cn.com.poc.thirdparty.resource.demand.pay.dto.DgtoolsPayOrderDto;
import cn.com.poc.thirdparty.resource.demand.pay.entity.DgtoolsPayOrderEntity;
import cn.com.poc.thirdparty.resource.demand.pay.entity.RetainInformation;

/**
 * @author Roger Wu
 */
public class DgtoolsPayOrderConvert {

    public static DgtoolsPayOrderDto convertEntity2Dto(DgtoolsPayOrderEntity dgToolsDgtoolsPayOrderEntity) {
        DgtoolsPayOrderDto prePayOrderDto = new DgtoolsPayOrderDto();
        prePayOrderDto.setPayOrderSn(dgToolsDgtoolsPayOrderEntity.getPayOrderSn());
        prePayOrderDto.setPayOrderType(dgToolsDgtoolsPayOrderEntity.getPayOrderType());
        prePayOrderDto.setTotalAmount(dgToolsDgtoolsPayOrderEntity.getTotalAmount());
        prePayOrderDto.setPaidAmount(dgToolsDgtoolsPayOrderEntity.getPaidAmount());
        prePayOrderDto.setNeedPayAmount(dgToolsDgtoolsPayOrderEntity.getNeedPayAmount());
        prePayOrderDto.setCurrency(dgToolsDgtoolsPayOrderEntity.getCurrency());
        if (StringUtils.isNotEmpty(dgToolsDgtoolsPayOrderEntity.getRetainInformation())) {
            prePayOrderDto.setRetainInformation(JsonUtils.deSerialize(dgToolsDgtoolsPayOrderEntity.getRetainInformation(), RetainInformation.class));
        }
        prePayOrderDto.setDescription(dgToolsDgtoolsPayOrderEntity.getDescription());
        prePayOrderDto.setOrderStatus(dgToolsDgtoolsPayOrderEntity.getOrderStatus());
        prePayOrderDto.setPayStatus(dgToolsDgtoolsPayOrderEntity.getPayStatus());
        prePayOrderDto.setMarketingGameFlowNo(dgToolsDgtoolsPayOrderEntity.getMarketingGameFlowNo());
        prePayOrderDto.setMemberId(dgToolsDgtoolsPayOrderEntity.getMemberId());
        prePayOrderDto.setPayTime(dgToolsDgtoolsPayOrderEntity.getPayTime());
        prePayOrderDto.setCancelTime(dgToolsDgtoolsPayOrderEntity.getCancelTime());
        prePayOrderDto.setCorpInfoId(dgToolsDgtoolsPayOrderEntity.getCorpInfoId());
        prePayOrderDto.setMerchantId(dgToolsDgtoolsPayOrderEntity.getMerchantId());
        prePayOrderDto.setAmount(dgToolsDgtoolsPayOrderEntity.getAmount());
        prePayOrderDto.setCreator(dgToolsDgtoolsPayOrderEntity.getCreator());
        prePayOrderDto.setCreatedTime(dgToolsDgtoolsPayOrderEntity.getCreatedTime());
        return prePayOrderDto;
    }

    public static DgtoolsPayOrderEntity convertDto2Entity(DgtoolsPayOrderDto dgToolsPayOrderDto) {
        DgtoolsPayOrderEntity dgToolsDgtoolsPayOrderEntity = new DgtoolsPayOrderEntity();
        dgToolsDgtoolsPayOrderEntity.setPayOrderSn(dgToolsPayOrderDto.getPayOrderSn());
        dgToolsDgtoolsPayOrderEntity.setPayOrderType(dgToolsPayOrderDto.getPayOrderType());
        dgToolsDgtoolsPayOrderEntity.setTotalAmount(dgToolsPayOrderDto.getTotalAmount());
        dgToolsDgtoolsPayOrderEntity.setPaidAmount(dgToolsPayOrderDto.getPaidAmount());
        dgToolsDgtoolsPayOrderEntity.setNeedPayAmount(dgToolsPayOrderDto.getNeedPayAmount());
        dgToolsDgtoolsPayOrderEntity.setCurrency(dgToolsPayOrderDto.getCurrency());
        dgToolsDgtoolsPayOrderEntity.setRetainInformation(JsonUtils.serialize(dgToolsPayOrderDto.getRetainInformation()));
        dgToolsDgtoolsPayOrderEntity.setDescription(dgToolsPayOrderDto.getDescription());
        dgToolsDgtoolsPayOrderEntity.setOrderStatus(dgToolsPayOrderDto.getOrderStatus());
        dgToolsDgtoolsPayOrderEntity.setPayStatus(dgToolsPayOrderDto.getPayStatus());
        dgToolsDgtoolsPayOrderEntity.setMarketingGameFlowNo(dgToolsPayOrderDto.getMarketingGameFlowNo());
        dgToolsDgtoolsPayOrderEntity.setMemberId(dgToolsPayOrderDto.getMemberId());
        dgToolsDgtoolsPayOrderEntity.setPayTime(dgToolsPayOrderDto.getPayTime());
        dgToolsDgtoolsPayOrderEntity.setCancelTime(dgToolsPayOrderDto.getCancelTime());
        dgToolsDgtoolsPayOrderEntity.setCorpInfoId(dgToolsPayOrderDto.getCorpInfoId());
        dgToolsDgtoolsPayOrderEntity.setMerchantId(dgToolsPayOrderDto.getMerchantId());
        dgToolsDgtoolsPayOrderEntity.setAmount(dgToolsPayOrderDto.getAmount());
        dgToolsDgtoolsPayOrderEntity.setCreator(dgToolsPayOrderDto.getCreator());
        dgToolsDgtoolsPayOrderEntity.setCreatedTime(dgToolsPayOrderDto.getCreatedTime());;
        return dgToolsDgtoolsPayOrderEntity;
    }

}
