package cn.com.poc.thirdparty.resource.demand.pay.model;

import cn.com.yict.framemax.data.model.BaseModelClass;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.*;
import java.io.Serializable;

/**
 * Model class for biz_order
 */
@Entity
@Table(name = "biz_order")
@DynamicInsert
@DynamicUpdate
public class BizOrderModel extends BaseModelClass implements Serializable {

    private static final long serialVersionUID = 1L;


    /**
     * order_id
     * 订单id
     */
    private Integer orderId;

    @Column(name = "order_id", length = 10)
    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    public Integer getOrderId() {
        return this.orderId;
    }

    public void setOrderId(Integer orderId) {
        this.orderId = orderId;
        super.addValidField("orderId");
    }


    /**
     * order_sn
     * 订单编号
     */
    private String orderSn;

    @Column(name = "order_sn", length = 50)
    public String getOrderSn() {
        return this.orderSn;
    }

    public void setOrderSn(String orderSn) {
        this.orderSn = orderSn;
        super.addValidField("orderSn");
    }


    /**
     * order_type
     * 订单类型
     */
    private String orderType;

    @Column(name = "order_type", length = 50)
    public String getOrderType() {
        return this.orderType;
    }

    public void setOrderType(String orderType) {
        this.orderType = orderType;
        super.addValidField("orderType");
    }


    /**
     * member_id
     * 会员id
     */
    private Integer memberId;

    @Column(name = "member_id", length = 10)
    public Integer getMemberId() {
        return this.memberId;
    }

    public void setMemberId(Integer memberId) {
        this.memberId = memberId;
        super.addValidField("memberId");
    }


    /**
     * total_amount
     * 订单金额(分)
     */
    private Integer totalAmount;

    @Column(name = "total_amount", length = 10)
    public Integer getTotalAmount() {
        return this.totalAmount;
    }

    public void setTotalAmount(Integer totalAmount) {
        this.totalAmount = totalAmount;
        super.addValidField("totalAmount");
    }


    /**
     * paid_amount
     * 已付金额(分)
     */
    private Integer paidAmount;

    @Column(name = "paid_amount", length = 10)
    public Integer getPaidAmount() {
        return this.paidAmount;
    }

    public void setPaidAmount(Integer paidAmount) {
        this.paidAmount = paidAmount;
        super.addValidField("paidAmount");
    }


    /**
     * need_pay_amount
     * 订单待付金额(分)
     */
    private Integer needPayAmount;

    @Column(name = "need_pay_amount", length = 10)
    public Integer getNeedPayAmount() {
        return this.needPayAmount;
    }

    public void setNeedPayAmount(Integer needPayAmount) {
        this.needPayAmount = needPayAmount;
        super.addValidField("needPayAmount");
    }


    /**
     * currency
     * 币种
     */
    private String currency;

    @Column(name = "currency", length = 10)
    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
        super.addValidField("currency");
    }


    /**
     * order_status
     * 订单状态:
     * Create-创建;
     * Processing-进行中;
     * Completed-完成;
     * Cancel-取消;
     */
    private String orderStatus;

    @Column(name = "order_status", length = 255)
    public String getOrderStatus() {
        return this.orderStatus;
    }

    public void setOrderStatus(String orderStatus) {
        this.orderStatus = orderStatus;
        super.addValidField("orderStatus");
    }


    /**
     * pay_status
     * 支付状态:
     * NoPayment-待支付;
     * Refunding-退款中;
     * Paid-已付款;
     * Cancel-已取消;
     */
    private String payStatus;

    @Column(name = "pay_status", length = 255)
    public String getPayStatus() {
        return this.payStatus;
    }

    public void setPayStatus(String payStatus) {
        this.payStatus = payStatus;
        super.addValidField("payStatus");
    }


    /**
     * pay_time
     * 付款时间
     */
    private java.util.Date payTime;

    @Column(name = "pay_time", length = 19)
    public java.util.Date getPayTime() {
        return this.payTime;
    }

    public void setPayTime(java.util.Date payTime) {
        this.payTime = payTime;
        super.addValidField("payTime");
    }


    /**
     * cancel_time
     * 订单取消时间
     */
    private java.util.Date cancelTime;

    @Column(name = "cancel_time", length = 19)
    public java.util.Date getCancelTime() {
        return this.cancelTime;
    }

    public void setCancelTime(java.util.Date cancelTime) {
        this.cancelTime = cancelTime;
        super.addValidField("cancelTime");
    }


    /**
     * merchant_id
     * 商家号
     */
    private Integer merchantId;

    @Column(name = "merchant_id", length = 10)
    public Integer getMerchantId() {
        return this.merchantId;
    }

    public void setMerchantId(Integer merchantId) {
        this.merchantId = merchantId;
        super.addValidField("merchantId");
    }


    /**
     * is_deleted
     * 是否删除 Y 是  N 否
     */
    private String isDeleted;

    @Column(name = "is_deleted", length = 1)
    public String getIsDeleted() {
        return this.isDeleted;
    }

    public void setIsDeleted(String isDeleted) {
        this.isDeleted = isDeleted;
        super.addValidField("isDeleted");
    }


    /**
     * CREATOR
     * 创建人
     */
    private String creator;

    @Column(name = "CREATOR", length = 11)
    public String getCreator() {
        return this.creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
        super.addValidField("creator");
    }


    /**
     * CREATED_TIME
     * 创建时间
     */
    private java.util.Date createdTime;

    @Column(name = "CREATED_TIME", length = 19)
    public java.util.Date getCreatedTime() {
        return this.createdTime;
    }

    public void setCreatedTime(java.util.Date createdTime) {
        this.createdTime = createdTime;
        super.addValidField("createdTime");
    }


    /**
     * MODIFIER
     * 修改人
     */
    private String modifier;

    @Column(name = "MODIFIER", length = 11)
    public String getModifier() {
        return this.modifier;
    }

    public void setModifier(String modifier) {
        this.modifier = modifier;
        super.addValidField("modifier");
    }


    /**
     * MODIFIED_TIME
     * 修改时间
     */
    private java.util.Date modifiedTime;

    @Column(name = "MODIFIED_TIME", length = 19)
    public java.util.Date getModifiedTime() {
        return this.modifiedTime;
    }

    public void setModifiedTime(java.util.Date modifiedTime) {
        this.modifiedTime = modifiedTime;
        super.addValidField("modifiedTime");
    }


    /**
     * SYS_VERSION
     * 乐观锁,版本号
     */
    private Integer sysVersion;

    @Column(name = "SYS_VERSION", length = 10)
    @Version
    public Integer getSysVersion() {
        return this.sysVersion;
    }

    public void setSysVersion(Integer sysVersion) {
        this.sysVersion = sysVersion;
        super.addValidField("sysVersion");
    }


}