package cn.com.poc.thirdparty.resource.demand.pay.model;

import cn.com.yict.framemax.data.model.BaseModelClass;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.*;
import java.io.Serializable;

/**
 * Model class for dgtools_pay_log
 * 
 */
@Entity
@Table(name = "dgtools_pay_log")
@DynamicInsert
@DynamicUpdate
public class DgtoolsPayLogModel extends BaseModelClass implements Serializable {

    private static final long serialVersionUID = 1L;
    
  
    /** pay_log_id
    *支付记录id
    */ 
    private Integer payLogId;
    
    @Column(name = "pay_log_id",length = 10)
	@Id @GeneratedValue(strategy = GenerationType.AUTO) 
    public Integer getPayLogId(){
        return this.payLogId;
    }
    
    public void setPayLogId(Integer payLogId){
        this.payLogId = payLogId;
        super.addValidField("payLogId");
    }
    
  
    /** pay_log_sn
    *
    */ 
    private String payLogSn;
    
    @Column(name = "pay_log_sn",length = 255)
    public String getPayLogSn(){
        return this.payLogSn;
    }
    
    public void setPayLogSn(String payLogSn){
        this.payLogSn = payLogSn;
        super.addValidField("payLogSn");
    }

    /** third_parth_pay_log_sn
    *
    */
    private String thirdParthPayLogSn;

    @Column(name = "third_parth_pay_log_sn",length = 255)
    public String getThirdParthPayLogSn() {
        return thirdParthPayLogSn;
    }

    public void setThirdParthPayLogSn(String thirdParthPayLogSn) {
        this.thirdParthPayLogSn = thirdParthPayLogSn;
        super.addValidField("thirdParthPayLogSn");

    }

    /** pay_order_sn
    *
    */ 
    private String payOrderSn;
    
    @Column(name = "pay_order_sn",length = 255)
    public String getPayOrderSn(){
        return this.payOrderSn;
    }
    
    public void setPayOrderSn(String payOrderSn){
        this.payOrderSn = payOrderSn;
        super.addValidField("payOrderSn");
    }
    
  
    /** paid_amount
    *已付金额(分)
    */ 
    private Integer paidAmount;
    
    @Column(name = "paid_amount",length = 10)
    public Integer getPaidAmount(){
        return this.paidAmount;
    }
    
    public void setPaidAmount(Integer paidAmount){
        this.paidAmount = paidAmount;
        super.addValidField("paidAmount");
    }
    
  
    /** currency
    *币种
    */ 
    private String currency;
    
    @Column(name = "currency",length = 10)
    public String getCurrency(){
        return this.currency;
    }
    
    public void setCurrency(String currency){
        this.currency = currency;
        super.addValidField("currency");
    }
    
  
    /** pay_status
    *支付状态:
NoPayment-待支付;
Paid-已付款;
Canele-已取消
    */ 
    private String payStatus;
    
    @Column(name = "pay_status",length = 255)
    public String getPayStatus(){
        return this.payStatus;
    }
    
    public void setPayStatus(String payStatus){
        this.payStatus = payStatus;
        super.addValidField("payStatus");
    }
    
  
    /** pay_time
    *付款时间
    */ 
    private java.util.Date payTime;
    
    @Column(name = "pay_time",length = 19)
    public java.util.Date getPayTime(){
        return this.payTime;
    }
    
    public void setPayTime(java.util.Date payTime){
        this.payTime = payTime;
        super.addValidField("payTime");
    }
    
  
    /** member_id
    *会员id
    */ 
    private Integer memberId;
    
    @Column(name = "member_id",length = 10)
    public Integer getMemberId(){
        return this.memberId;
    }
    
    public void setMemberId(Integer memberId){
        this.memberId = memberId;
        super.addValidField("memberId");
    }
    
  
    /** merchant_id
    *商家号
    */ 
    private Integer merchantId;
    
    @Column(name = "merchant_id",length = 10)
    public Integer getMerchantId(){
        return this.merchantId;
    }
    
    public void setMerchantId(Integer merchantId){
        this.merchantId = merchantId;
        super.addValidField("merchantId");
    }

    /** corp_info_id
     *
     */
    private Integer corpInfoId;

    @Column(name = "corp_info_id",length = 10)

    public Integer getCorpInfoId(){
        return this.corpInfoId;
    }

    public void setCorpInfoId(Integer corpInfoId){
        this.corpInfoId = corpInfoId;
        super.addValidField("merchantId");
    }
    
  
    /** is_deleted
    *是否删除 Y 是  N 否
    */ 
    private String isDeleted;
    
    @Column(name = "is_deleted",length = 1)
    public String getIsDeleted(){
        return this.isDeleted;
    }
    
    public void setIsDeleted(String isDeleted){
        this.isDeleted = isDeleted;
        super.addValidField("isDeleted");
    }
    
  
    /** CREATOR
    *创建人
    */ 
    private String creator;
    
    @Column(name = "CREATOR",length = 11)
    public String getCreator(){
        return this.creator;
    }
    
    public void setCreator(String creator){
        this.creator = creator;
        super.addValidField("creator");
    }
    
  
    /** CREATED_TIME
    *创建时间
    */ 
    private java.util.Date createdTime;
    
    @Column(name = "CREATED_TIME",length = 19)
    public java.util.Date getCreatedTime(){
        return this.createdTime;
    }
    
    public void setCreatedTime(java.util.Date createdTime){
        this.createdTime = createdTime;
        super.addValidField("createdTime");
    }
    
  
    /** MODIFIER
    *修改人
    */ 
    private String modifier;
    
    @Column(name = "MODIFIER",length = 11)
    public String getModifier(){
        return this.modifier;
    }
    
    public void setModifier(String modifier){
        this.modifier = modifier;
        super.addValidField("modifier");
    }
    
  
    /** MODIFIED_TIME
    *修改时间
    */ 
    private java.util.Date modifiedTime;
    
    @Column(name = "MODIFIED_TIME",length = 19)
    public java.util.Date getModifiedTime(){
        return this.modifiedTime;
    }
    
    public void setModifiedTime(java.util.Date modifiedTime){
        this.modifiedTime = modifiedTime;
        super.addValidField("modifiedTime");
    }
    
  
    /** SYS_VERSION
    *乐观锁,版本号
    */ 
    private Integer sysVersion;
    
    @Column(name = "SYS_VERSION",length = 10)
	@Version
    public Integer getSysVersion(){
        return this.sysVersion;
    }
    
    public void setSysVersion(Integer sysVersion){
        this.sysVersion = sysVersion;
        super.addValidField("sysVersion");
    }
    

}