import { request } from '@/utils/request'

/**
 * @query agentId 应用Id channel 渠道
 * @returns 应用用量数据
 */
export function fetchGetGeneralUsageData<T>(agentId: string, channel: string[]) {
  return request.post<T>(`/agentDataAnalyzeRest/getGeneralUsageData.json?agentId=${agentId}&channel=${channel}`)
}

/**
 * @params payload
 * @returns 应用趋势图数据
 */
export function fetchGetAgentDataTrend<T>(payload: {
  agentId: string
  channel: string[]
  timeRange: { rangType: string; startTime: string; endTime: string }
}) {
  return request.post<T>('/agentDataAnalyzeRest/getAgentDataTrend.json', payload)
}

/**
 * @query agentId 应用Id channel 渠道
 * @returns 本月使用人数据
 */
export function fetchGetMonthUserCount<T>(agentId: string, channel: string[]) {
  return request.post<T>(`/agentDataAnalyzeRest/getChannelUsersCount.json?agentId=${agentId}&channel=${channel}`)
}

/**
 * @query agentId 应用Id channel 渠道
 * @returns 本月发送消息数据
 */
export function fetchGetMonthSendMessageCount<T>(agentId: string, channel: string[]) {
  return request.post<T>(`/agentDataAnalyzeRest/getSendMessageCount.json?agentId=${agentId}&channel=${channel}`)
}

/**
 * @query agentId 应用Id channel 渠道
 * @returns 本月消耗积分数据
 */
export function fetchGetMonthConsumePointCount<T>(agentId: string, channel: string[]) {
  return request.post<T>(`/agentDataAnalyzeRest/getPointUsageCount.json?agentId=${agentId}&channel=${channel}`)
}

/**
 * @params { agentId: 应用Id timeRange: { rangType: 类型, startTime: 开始时间, endTime: 结束时间 }}
 * @returns API渠道积分使用情况
 */
export function fetchGetAPIChannelPointUsageCount<T>(payload: {
  agentId: string
  timeRange: {
    rangType: 'today' | 'week' | 'month' | 'customize'
    startTime: string
    endTime: string
  }
}) {
  return request.post<T>('/agentDataAnalyzeRest/getApiChannelPointUsageCount.json', payload)
}

/**
 * @params { reportRequestType：导出类型 agentId: 应用Id timeRange: { rangType: 类型, startTime: 开始时间, endTime: 结束时间 }}
 * @returns API调用积分消耗报表导出
 */
export function fetchReportAPIChannelPointUsage<T>(payload: {
  reportRequestType: string
  agentId: string
  timeRange: {
    rangType: 'today' | 'week' | 'month' | 'customize'
    startTime: string
    endTime: string
  }
}) {
  return request.post<T>('/formReportingRest/report.json', payload, {
    ignoreErrorCheck: true,
    responseType: 'blob',
    timeout: 0,
  })
}
