import { request } from '@/utils/request'
import type { AxiosProgressEvent } from 'axios'

export function fetchAgentApplicationSelectList<T>() {
  return request.post<T>('/agentApplicationRest/getDefaultList.json', {
    query: '',
    pagingInfo: { pageNo: 1, pageSize: 99999 },
  })
}

export function fetchCreateSessionId<T>() {
  return request.post<T>('/agentApplicationRest/createDialogues.json')
}

export function fetchRecommendQuestionList<T>() {
  return request.post<T>('/agentApplicationRest/getRecommendQuestions.json')
}

export function fetchSessionHistoryRecordList<T>() {
  return request.post<T>('/agentApplicationRest/getUserDialogues.json')
}

export function fetchHistoryRecordDelete<T>(recordIdList: string[]) {
  return request.post<T>('/agentApplicationRest/batchCloseDialogues.json', recordIdList)
}

export function fetchMessageRecordList<T>(dialogueId: string) {
  return request.post<T>(`/agentApplicationRest/getDialogueContext.json?dialogueId=${dialogueId}`, null, {
    timeout: 12000,
  })
}

export function fetchFileUpload<T>(
  formData: FormData,
  config: { onUploadProgress: (progressEvent?: AxiosProgressEvent) => void; signal?: AbortSignal } = {
    onUploadProgress: () => {},
  },
) {
  return request.post<T>(`/bosRest/upload.json`, formData, {
    headers: { 'Content-Type': 'multipart/form-data' },
    timeout: 0,
    onUploadProgress: config.onUploadProgress,
    signal: config.signal,
  })
}

export function fetchSceneList<T>() {
  return request.post<T>('/agentApplicationRest/getHomePlugins.json?search=')
}
