import { request } from '@/utils/request'

export function fetchGetLongMemoryList<T>(agentId: string) {
  return request.post<T>(`/agentApplicationInfoRest/getLongMemoryList.json?agentId=${agentId}`)
}

export function fetchDeleteLongMemoryByKey<T>(agentId: string, timestamp: string) {
  return request.post<T>(
    `/agentApplicationInfoRest/deleteLongMemoryByKey.json?agentId=${agentId}&timestamp=${timestamp}`,
  )
}

export function fetchDeleteAllLongMemory<T>(agentId: string) {
  return request.post<T>(`/agentApplicationInfoRest/deleteLongMemory.json?agentId=${agentId}`)
}

export function fetchGetMemoryVariableList<T>(agentId: string) {
  return request.post<T>(`/agentApplicationInfoRest/getVariableList.json?agentId=${agentId}`)
}
