import { request } from '@/utils/request'
import { AxiosProgressEvent } from 'axios'

export function fetchUpload<T>(
  formdata: FormData,
  config?: { onUploadProgress?: (progressEvent: AxiosProgressEvent) => void },
) {
  return request.post<T>('/bosRest/upload.json', formdata, {
    headers: { 'Content-Type': 'multipart/form-data' },
    timeout: 120000,
    ...(config?.onUploadProgress ? { onUploadProgress: config.onUploadProgress } : {}),
  })
}
