import { reactive } from 'vue'

export interface DefaultPaginationData {
  pageNo: number
  pageSize: number
  totalPages: number
  totalRows: number
}

interface PaginationData {
  pageNo?: number
  pageSize?: number
  totalPages?: number
  totalRows?: number
}

/** 默认的分页参数 */
const defaultPaginationData: DefaultPaginationData = {
  pageNo: 1,
  pageSize: 10,
  totalPages: 0,
  totalRows: 0,
}

export function usePagination(initialPaginationData: PaginationData = {}) {
  /** 合并分页参数 */
  const paginationData = reactive({ ...defaultPaginationData, ...initialPaginationData })
  /** 改变当前页码 */
  const handlePageNoChange = (pageNo: number) => {
    paginationData.pageNo = pageNo
  }
  /** 改变页面大小 */
  const handlePageSizeChange = (pageSize: number) => {
    paginationData.pageNo = 1
    paginationData.pageSize = pageSize
  }

  return { paginationData, handlePageNoChange, handlePageSizeChange }
}
