import type { SmartFormTypes } from '../types'
import { ResponseBusinessTripForm, BusinessTripForm } from '@/views/home/components/smart-forms/types'

export function smartFormTypeConverter(type: 'travelForm'): SmartFormTypes {
  switch (type) {
    case 'travelForm':
      return 'BusinessTripForm'
  }
}

export function businessTripFormParser(resForm: Partial<ResponseBusinessTripForm>) {
  return {
    objective: resForm.purpose || 'CustomerVisits',
    travelLocation: resForm.place || '',
    departureTime: resForm.departureDate ? Date.parse(resForm.departureDate) : null,
    returnTime: resForm.returnDate ? Date.parse(resForm.returnDate) : null,
    vehicle: resForm.vehicle || '',
    vehicleEstimatedCost: resForm.transportationFee ? Number.parseInt(resForm.transportationFee) : null,
    residence: resForm.accommodation || '',
    residenceEstimatedCost: resForm.accommodationCost ? Number.parseInt(resForm.accommodationCost) : null,
    advancePaymentAmount: resForm.advancePaymentAmount ? Number.parseInt(resForm.advancePaymentAmount) : null,
    generalBudget: resForm.totalBudget || '',
    email: '',
  }
}

export function businessTripFormReturner(form: BusinessTripForm) {
  return {
    purpose: form.objective,
    place: form.travelLocation,
    departureDate: form.departureTime ? new Date(form.departureTime).toISOString() : '',
    returnDate: form.returnTime ? new Date(form.returnTime).toISOString() : '',
    vehicle: form.vehicle,
    transportationFee: form.vehicleEstimatedCost,
    accommodation: form.residence,
    accommodationCost: form.residenceEstimatedCost,
    advancePaymentAmount: form.advancePaymentAmount,
    totalBudget: form.generalBudget,
  }
}
