import { h } from 'vue'
import CustomIcon from '@/components/custom-icon/custom-icon.vue'
import { formatDateTime } from '@/utils/date-formatter'
import i18n from '@/locales'

const t = i18n.global.t

export function createChannelPublishColumn(handleChannelPublishTableAction: (actionType: string) => void) {
  return [
    {
      title: () =>
        h('span', {}, t('personal_space_module.agent_module.agent_setting_module.agent_publish_module.channel')),
      key: 'channel',
      align: 'left',
      width: 540,
      render() {
        return h(
          'div',
          {
            style: {
              display: 'flex',
              justifyContent: 'flex-start',
              alignItems: 'center',
            },
          },
          {
            default: () => [
              h(CustomIcon, {
                width: '24px',
                icon: 'icon-park-solid:computer',
                color: '#000DFF',
              }),
              h(
                'div',
                {
                  style: {
                    display: 'flex',
                    flexDirection: 'column',
                    justifyContent: 'center',
                    alignItems: 'flex-start',
                    fontSize: '14px',
                    marginLeft: '12px',
                  },
                },
                {
                  default: () => [
                    h(
                      'span',
                      {},
                      t(
                        'personal_space_module.agent_module.agent_setting_module.agent_publish_module.web_channel_name',
                      ),
                    ),
                    h(
                      'span',
                      {
                        style: {
                          color: '#84868c',
                        },
                      },
                      t(
                        'personal_space_module.agent_module.agent_setting_module.agent_publish_module.web_channel_desc',
                      ),
                    ),
                  ],
                },
              ),
            ],
          },
        )
      },
    },
    {
      title: () => h('span', {}, t('common_module.status')),
      key: 'agentPublishStatus',
      align: 'left',
      width: 220,
      render() {
        return h(
          'div',
          {
            style: {
              display: 'flex',
              flexDirection: 'column',
              justifyContent: 'center',
              alignItems: 'flex-start',
            },
          },
          {
            default: () => [
              h(
                'div',
                {
                  style: {
                    background: '#34a853',
                    borderRadius: '4px',
                    padding: '2px 14px',
                    color: '#fff',
                    marginBottom: '4px',
                  },
                },
                t('common_module.published'),
              ),
              h(
                'span',
                {
                  style: {
                    color: '#84868c',
                  },
                },
                {
                  default: () => formatDateTime(new Date()) + t('common_module.publish'),
                },
              ),
            ],
          },
        )
      },
    },
    {
      title: () => h('span', {}, t('common_module.data_table_module.action')),
      key: 'action',
      align: 'left',
      width: '460',
      render() {
        return h(
          'div',
          {
            style: {
              display: 'flex',
              justifyContent: 'flex-start',
              alignItems: 'center',
            },
          },
          {
            default: () => [
              h(
                'div',
                {
                  style: {
                    display: 'flex',
                    justifyContent: 'flex-start',
                    alignItems: 'center',
                    fontSize: '14px',
                    padding: '4px 12px',
                    background: '#f7f7f9',
                    borderColor: '#000DFF',
                    color: '#000DFF',
                  },
                  className: 'cursor-pointer rounded-md border hover:opacity-80',
                  onClick: () => handleChannelPublishTableAction('accessPage'),
                },
                {
                  default: () => [
                    h(CustomIcon, { icon: 'lets-icons:view', style: { marginRight: '6px', fontSize: '16px' } }),
                    h(
                      'span',
                      {},
                      t('personal_space_module.agent_module.agent_setting_module.agent_publish_module.access_page'),
                    ),
                  ],
                },
              ),
              h(
                'div',
                {
                  style: {
                    display: 'flex',
                    justifyContent: 'flex-start',
                    alignItems: 'center',
                    fontSize: '14px',
                    marginLeft: '16px',
                    padding: '4px 12px',
                    background: '#f7f7f9',
                  },
                  className: 'cursor-pointer hover:text-theme-color rounded-md border hover:border-theme-color',
                  onClick: () => handleChannelPublishTableAction('copyLink'),
                },
                {
                  default: () => [
                    h(CustomIcon, { icon: 'pepicons-pop:share-android-circle', style: { marginRight: '6px' } }),
                    h(
                      'span',
                      {},
                      t('personal_space_module.agent_module.agent_setting_module.agent_publish_module.share_link'),
                    ),
                  ],
                },
              ),
            ],
          },
        )
      },
    },
  ]
}
