import { request } from '@/utils/request'

export function fetchAgentApplicationSelectList<T>() {
  return request.post<T>('/agentApplicationRest/getDefaultList.json', {
    query: '',
    pagingInfo: { pageNo: 1, pageSize: 99999 },
  })
}

export function fetchCreateSessionId<T>() {
  return request.post<T>('/agentApplicationRest/createDialogues.json')
}

export function fetchRecommendQuestionList<T>() {
  return request.post<T>('/agentApplicationRest/getRecommendQuestions.json')
}

export function fetchSessionHistoryRecordList<T>() {
  return request.post<T>('/agentApplicationRest/getUserDialogues.json')
}

export function fetchHistoryRecordDelete<T>(recordIdList: string[]) {
  return request.post<T>('/agentApplicationRest/batchCloseDialogues.json', recordIdList)
}

export function fetchMessageRecordList<T>(dialogueId: string) {
  return request.post<T>(`/agentApplicationRest/getDialogueContext.json?dialogueId=${dialogueId}`)
}
