import { createDiscreteApi } from 'naive-ui'
import type { DialogApiInjection, DialogOptions, DialogReactive } from 'naive-ui/es/dialog/src/DialogProvider'
import i18n from '@/locales'

const { t } = i18n.global

/* 拦截一层添加默认配置 */
function createDialogProvider(dialog: DialogApiInjection): DialogApiInjection {
  /* 默认配置 */
  const defaultConfig: DialogOptions = {
    style: 'margin-top: 180px',
    titleStyle: 'font-size: 16px',
    contentStyle: 'margin-left: 32px',
    negativeText: t('common_module.cancel_btn_text'),
    positiveText: t('common_module.confirm_btn_text'),
  }

  return {
    destroyAll() {
      dialog.destroyAll()
    },
    create(options: DialogOptions): DialogReactive {
      return dialog.create(Object.assign(defaultConfig, options))
    },
    success(options: DialogOptions): DialogReactive {
      return dialog.success(Object.assign(defaultConfig, options))
    },
    warning(options: DialogOptions): DialogReactive {
      return dialog.warning(Object.assign(defaultConfig, options))
    },
    error(options: DialogOptions): DialogReactive {
      return dialog.error(Object.assign(defaultConfig, options))
    },
    info(options: DialogOptions): DialogReactive {
      return dialog.info(Object.assign(defaultConfig, options))
    },
  }
}

export function setupDiscrete() {
  const { message, notification, loadingBar, dialog } = createDiscreteApi(
    ['message', 'dialog', 'notification', 'loadingBar'],
    {
      configProviderProps: {
        themeOverrides: {
          LoadingBar: {
            colorLoading: import.meta.env.VITE_APP_THEME_COLOR,
          },
        },
      },
    },
  )

  window.$message = message
  window.$notification = notification
  window.$loadingBar = loadingBar
  window.$dialog = createDialogProvider(dialog)
}
