export enum TrainStatus {
  UNOPENED = 'Unopened',
  LINE = 'Line',
  TRAINING = 'Training',
  COMPLETE = 'Complete',
  FAIL = 'Fail',
}

export interface KnowledgeItem {
  id: number
  knowledgeName: string
  desc: string
  trainStatus: TrainStatus
  isOpen: 'Y' | 'N'
  createdTime: Date
  documentInfos: KnowledgeDocumentItem[]
}

export interface SegmentationConfigInterface {
  segmentationType: 'Default'
  chunkSize: number
  scrapSize: number
  repetitionRate: number
  relationInfo: string[]
  regex: string
  punctuations: string
}

export interface KnowledgeDocumentItem {
  kdId: number
  knowledgeType: string
  documentName: string
  documentUrl: string
  charCount: number
  uploadTime: Date
  isEnable: 'Y' | 'N'
  knowledgeId: string
  trainStatus: TrainStatus
  segmentationConfig: SegmentationConfigInterface
}

export interface KnowledgeChunkItem {
  knowledgeId: string
  chunkContent: string
  chunkRelationId: string
  chunkSort: number
  isOpen: 'Y' | 'N'
}
