import { request } from '@/utils/request'

/**
 * @query channels 渠道列表
 * @returns 平台积分使用情况
 */
export function fetchGetPlatformPointUsage<T>(channels: string[]) {
  return request.post<T>(`/dataStatisticsRest/platformPointUsage.json?channels=${channels}`)
}

/**
 * @param { channel: 渠道列表 timeRange: { rangType: 类型, startTime: 开始时间, endTime: 结束时间 } }
 * @returns 平台积分使用趋势
 */
export function fetchGetPlatformPointTrend<T>(payload: {
  channel: string[]
  timeRange: { rangType: string; startTime: string; endTime: string }
}) {
  return request.post<T>('/dataStatisticsRest/platformPointTrend.json', payload)
}

/**
 * @query channels 渠道列表
 * @returns 平台应用使用情况
 */
export function fetchGetPlatformAgentUsage<T>(channels: string[]) {
  return request.post<T>(`/dataStatisticsRest/platformAgentUsage.json?channels=${channels}`)
}

/**
 * @params { timeRange: { rangType: 类型, startTime: 开始时间, endTime: 结束时间 } }
 * @returns 平台应用使用明细
 */
export function fetchGetPlatformAgentUsageDetail<T>(payload: {
  timeRange: {
    rangType: 'month' | 'week' | 'customize'
    startTime: string
    endTime: string
  }
  pagingInfo: {
    pageNo: number
    pageSize: number
  }
}) {
  return request.post<T>('/dataStatisticsRest/platformAgentUsageDetail.json', payload)
}
