import { type RouteRecordRaw } from 'vue-router'
import Layout from '@/layout/index.vue'

export default [
  {
    path: '/personal-space-layout',
    name: 'PersonalSpace-Layout',
    meta: {
      rank: 1001,
      title: 'router_title_module.personal',
      icon: 'mingcute:user-2-line',
      belong: 'personal-space',
    },
    component: Layout,
    redirect: '/personal-space',
    children: [
      {
        path: '/personal-space',
        name: 'PersonalSpace',
        meta: {
          rank: 1001,
          title: 'router_title_module.personal',
          belong: 'PersonalSpace',
        },
        component: () => import('@/views/personal-space/personal-space.vue'),
        redirect: '/personal-space/app',
        children: [
          {
            path: 'app',
            name: 'PersonalSpaceApp',
            meta: {
              rank: 1001,
              title: 'router_title_module.agent_application',
              belong: 'PersonalSpace',
            },
            component: () => import('@/views/personal-space/personal-app/personal-app.vue'),
          },
          {
            path: 'knowledge',
            name: 'PersonalSpaceKnowledge',
            meta: {
              rank: 1001,
              title: 'router_title_module.knowledge',
              belong: 'PersonalSpace',
            },
            component: () => import('@/views/personal-space/personal-knowledge/personal-knowledge.vue'),
          },
        ],
      },

      {
        path: '/knowledge/document/:id',
        name: 'KnowledgeDocument',
        meta: {
          rank: 1001,
          title: 'router_title_module.knowledge_document_list',
          belong: 'PersonalSpace',
        },
        component: () => import('@/views/personal-space/personal-knowledge/personal-document.vue'),
      },

      {
        path: '/knowledge/document/detail/:id/:kdId',
        name: 'KnowledgeDocumentDetail',
        meta: {
          rank: 1001,
          title: 'router_title_module.knowledge_document_detail',
          belong: 'PersonalSpace',
        },
        component: () => import('@/views/personal-space/personal-knowledge/knowledge-detail/knowledge-detail.vue'),
      },

      {
        path: '/knowledge/upload/:id/:type?',
        name: 'UploadKnowledge',
        meta: {
          rank: 1001,
          title: 'router_title_module.upload_knowledge_document',
          belong: 'PersonalSpace',
        },
        component: () => import('@/views/personal-space/personal-knowledge/upload-knowledge/upload-knowledge.vue'),
      },
    ],
  },
  {
    path: '/personal-app-setting/:agentId?/:tabKey?',
    name: 'PersonalAppSetting',
    meta: {
      rank: 1001,
      title: 'router_title_module.app_setting',
      icon: 'mingcute:user-2-line',
      belong: 'PersonalAppSetting',
      hideSideMenItem: true,
    },
    component: () => import('@/views/personal-space/personal-app-setting/personal-app-setting.vue'),
  },
] as RouteRecordRaw[]
