import { type RouteRecordRaw } from 'vue-router'
import Layout from '@/layout/index.vue'

export default [
  {
    path: '/statistic-layout',
    name: 'StatisticLayout',
    meta: {
      rank: 1001,
      title: '',
    },
    component: Layout,
    redirect: '/statistic',
    children: [
      {
        path: '/statistic',
        name: 'Statistic',
        meta: {
          rank: 1001,
          title: 'router_title_module.data_statistic',
        },
        component: () => import('@/views/statistics/statistics.vue'),
        redirect: '/statistic/point-statistic',
        children: [
          {
            path: '/statistic/point-statistic',
            name: 'PointStatistic',
            meta: {
              rank: 1001,
              title: 'router_title_module.data_statistic',
              belong: 'Statistic',
            },
            component: () => import('@/views/statistics/point-statistic/point-static.vue'),
          },
          {
            path: '/statistic/agent-statistic',
            name: 'AgentStatistic',
            meta: {
              rank: 1001,
              title: 'router_title_module.data_statistic',
              belong: 'Statistic',
            },
            component: () => import('@/views/statistics/agent-statistic/agent-statistic.vue'),
          },
        ],
      },
    ],
  },
] as RouteRecordRaw[]
